import SampleLocale from "date-fns/locale/en-US";
import { IUtils } from "@date-io/core/IUtils";
declare type Locale = typeof SampleLocale;
export default class DateFnsUtils implements IUtils<Date> {
    locale?: Locale;
    yearFormat: string;
    yearMonthFormat: string;
    dateTime12hFormat: string;
    dateTime24hFormat: string;
    time12hFormat: string;
    time24hFormat: string;
    dateFormat: string;
    constructor({ locale }?: {
        locale?: Locale;
    });
    addDays(value: Date, count: number): Date;
    isValid(value: any): boolean;
    getDiff(value: Date, comparing: Date | string): number;
    isAfter(value: Date, comparing: Date): boolean;
    isBefore(value: Date, comparing: Date): boolean;
    startOfDay(value: Date): Date;
    endOfDay(value: Date): Date;
    getHours(value: Date): number;
    setHours(value: Date, count: number): Date;
    setMinutes(value: Date, count: number): Date;
    getSeconds(value: Date): number;
    setSeconds(value: Date, count: number): Date;
    isSameDay(value: Date, comparing: Date): boolean;
    isSameMonth(value: Date, comparing: Date): boolean;
    isSameYear(value: Date, comparing: Date): boolean;
    isSameHour(value: Date, comparing: Date): boolean;
    startOfMonth(value: Date): Date;
    endOfMonth(value: Date): Date;
    getYear(value: Date): number;
    setYear(value: Date, count: number): Date;
    date(value?: any): Date;
    parse(value: string, formatString: string): Date;
    format(date: Date, formatString: string): string;
    isEqual(date: any, comparing: any): boolean;
    isNull(date: Date): boolean;
    isAfterDay(date: Date, value: Date): boolean;
    isBeforeDay(date: Date, value: Date): boolean;
    isBeforeYear(date: Date, value: Date): boolean;
    isAfterYear(date: Date, value: Date): boolean;
    formatNumber(numberToFormat: string): string;
    getMinutes(date: Date): number;
    getMonth(date: Date): number;
    setMonth(date: Date, count: number): Date;
    getMeridiemText(ampm: "am" | "pm"): "AM" | "PM";
    getNextMonth(date: Date): Date;
    getPreviousMonth(date: Date): Date;
    getMonthArray(date: Date): Date[];
    mergeDateAndTime(date: Date, time: Date): Date;
    getWeekdays(): string[];
    getWeekArray(date: Date): Date[][];
    getYearRange(start: Date, end: Date): Date[];
    getCalendarHeaderText(date: Date): string;
    getYearText(date: Date): string;
    getDatePickerHeaderText(date: Date): string;
    getDateTimePickerHeaderText(date: Date): string;
    getMonthText(date: Date): string;
    getDayText(date: Date): string;
    getHourText(date: Date, ampm: boolean): string;
    getMinuteText(date: Date): string;
    getSecondText(date: Date): string;
}
export {};
