/// <reference types="react" />
import { MaterialUiPickersDate } from './date';
import { WrapperVariant } from '../wrappers/Wrapper';
import { ParsableDate } from '../constants/prop-types';
import { ToolbarComponentProps } from '../Picker/Picker';
export interface BasePickerProps {
    /** Picker value */
    value: ParsableDate;
    /** onChange callback @DateIOType */
    onChange: (date: MaterialUiPickersDate) => void;
    /**
     * Auto accept date on selection
     * @default false
     */
    autoOk?: boolean;
    /** Format string */
    format?: string;
    /** Disable picker and text field */
    disabled?: boolean;
    /** Make picker read only */
    readOnly?: boolean;
    /** Dynamic formatter of text field value @DateIOType */
    labelFunc?: (date: MaterialUiPickersDate, invalidLabel: string) => string;
    /** Date that will be initially highlighted if null was passed */
    initialFocusedDate?: ParsableDate;
    /**
     * Message displaying in text field if date is invalid (doesn't work in keyboard mode)
     * @default 'unknown'
     */
    invalidLabel?: string;
    /**
     * Message displaying in text field, if null passed (doesn't work in keyboard mode)
     * @default ' '
     */
    emptyLabel?: string;
    /** Callback fired when date is accepted @DateIOType */
    onAccept?: (date: MaterialUiPickersDate) => void;
    /** Callback fired when new error should be displayed
     * (!! This is a side effect. Be careful if you want to rerender the component) @DateIOType
     */
    onError?: (error: React.ReactNode, value: MaterialUiPickersDate | ParsableDate) => void;
    /** On open callback */
    onOpen?: () => void;
    /** On close callback */
    onClose?: () => void;
    /** Controlled picker open state */
    open?: boolean;
    /**
     * Hide toolbar and show only date/time views
     * @default false
     */
    disableToolbar?: boolean;
    /**
     * Force rendering in particular orientation
     * @default "portrait"
     */
    orientation?: 'portrait' | 'landscape';
    /** Component that will replace default toolbar renderer */
    ToolbarComponent?: React.ComponentType<ToolbarComponentProps>;
    variant?: WrapperVariant;
}
