declare type MissingWarningResolver = (propName: string, propValue: any, componentName: string) => string;
declare type InvalidWarningResolver = (propName: string, propValue: any, componentName: string, validationName: string) => string;
declare type Warnings = {
    missing?: MissingWarningResolver;
    invalid?: InvalidWarningResolver;
};
declare type CreatorOptions = {
    validationName: string;
    predicate: (propValue: any) => boolean;
    warnings?: Warnings;
};
/**
 * Creates a prop type generator function based on the provided options.
 */
export default function createPropType(options: CreatorOptions): any;
export {};
