// Karma configuration
// Generated on Mon Jan 09 2017 12:02:39 GMT+0800 (CST)
var webpackConfig = require('./webpack.test.config');

module.exports = function(config) {
  config.set({

    // base path that will be used to resolve all patterns (eg. files, exclude)
    basePath: './',

    // frameworks to use
    // available frameworks: https://npmjs.org/browse/keyword/karma-adapter
    frameworks: ['jasmine'],


    // list of files / patterns to load in the browser
    files: [
        'test/**/*.js'
    ],


    // list of files to exclude
    exclude: [
        'karma.conf.js',
        'rollup.config.js',
        'webpack.test.config.js'
    ],


    // preprocess matching files before serving them to the browser
    // available preprocessors: https://npmjs.org/browse/keyword/karma-preprocessor
    preprocessors: {
      './test/*.js': ['webpack']
    },

    webpack: webpackConfig,
    webpackMiddleware: {
      // webpack-dev-middleware configuration
      // i. e.
      stats: 'errors-only'
    },
    // babelPreprocessor: {
    //     options: {
    //         presets: ['es2015'],
    //         sourceMap: 'inline'
    //     },
    //     filename: function (file) {
    //         return file.originalPath.replace(/\.js$/, '.es5.js');
    //     },
    //     sourceFileName: function (file) {
    //         return file.originalPath;
    //     }
    // },


    // test results reporter to use
    // possible values: 'dots', 'progress'
    // available reporters: https://npmjs.org/browse/keyword/karma-reporter
    reporters: ['progress'],


    // web server port
    port: 9876,


    // enable / disable colors in the output (reporters and logs)
    colors: true,


    // level of logging
    // possible values: config.LOG_DISABLE || config.LOG_ERROR || config.LOG_WARN || config.LOG_INFO || config.LOG_DEBUG
    logLevel: config.LOG_INFO,


    // enable / disable watching file and executing tests whenever any file changes
    autoWatch: true,


    // start these browsers
    // available browser launchers: https://npmjs.org/browse/keyword/karma-launcher
    // browsers: ['Chrome', 'Safari', 'Firefox', 'IE', 'Opera', 'ChromeCanary'],
    browsers: ['Chrome'],


    // Continuous Integration mode
    // if true, Karma captures browsers, runs the tests and exits
    singleRun: false,

    // Concurrency level
    // how many browser should be started simultaneous
    concurrency: Infinity,

    plugins: [
        'karma-webpack',
        'karma-jasmine',
        // 'karma-mocha',
        // 'karma-coverage',
        // 'karma-firefox-launcher',
        // 'karma-opera-launcher',
        // 'karma-safari-launcher',
        // 'karma-ie-launcher',
        'karma-chrome-launcher'
    ],
  })
}
