import React from 'react';
import PropTypes from 'prop-types';
import type { formatHour as defaultFormatHour } from './shared/hourFormatter';
import { isHandWidth } from './shared/propTypes';
import type { ClassName, HandLength, HandWidth, MarkLength, MarkWidth, OppositeHandLength } from './shared/types';
type ClockProps = {
    className?: ClassName;
    formatHour?: typeof defaultFormatHour;
    hourHandLength?: HandLength;
    hourHandOppositeLength?: OppositeHandLength;
    hourHandWidth?: HandWidth;
    hourMarksLength?: MarkLength;
    hourMarksWidth?: MarkWidth;
    locale?: string;
    minuteHandLength?: HandLength;
    minuteHandOppositeLength?: OppositeHandLength;
    minuteHandWidth?: HandWidth;
    minuteMarksLength?: MarkLength;
    minuteMarksWidth?: MarkWidth;
    renderHourMarks?: boolean;
    renderMinuteHand?: boolean;
    renderMinuteMarks?: boolean;
    renderNumbers?: boolean;
    renderSecondHand?: boolean;
    secondHandLength?: HandLength;
    secondHandOppositeLength?: OppositeHandLength;
    secondHandWidth?: HandWidth;
    size?: React.CSSProperties['width'];
    value?: string | Date | null;
};
declare function Clock({ className, formatHour, hourHandLength, hourHandOppositeLength, hourHandWidth, hourMarksLength, hourMarksWidth, locale, minuteHandLength, minuteHandOppositeLength, minuteHandWidth, minuteMarksLength, minuteMarksWidth, renderHourMarks, renderMinuteHand, renderMinuteMarks, renderNumbers, renderSecondHand, secondHandLength, secondHandOppositeLength, secondHandWidth, size, value, }: ClockProps): JSX.Element;
declare namespace Clock {
    var propTypes: {
        className: PropTypes.Requireable<NonNullable<string | (string | null | undefined)[] | null | undefined>>;
        formatHour: PropTypes.Requireable<(...args: any[]) => any>;
        hourHandLength: (props: Record<string, unknown>, propName: string, componentName: string) => Error | null;
        hourHandOppositeLength: (props: Record<string, unknown>, propName: string, componentName: string) => Error | null;
        hourHandWidth: typeof isHandWidth;
        hourMarksLength: (props: Record<string, unknown>, propName: string, componentName: string) => Error | null;
        hourMarksWidth: typeof isHandWidth;
        locale: PropTypes.Requireable<string>;
        minuteHandLength: (props: Record<string, unknown>, propName: string, componentName: string) => Error | null;
        minuteHandOppositeLength: (props: Record<string, unknown>, propName: string, componentName: string) => Error | null;
        minuteHandWidth: typeof isHandWidth;
        minuteMarksLength: (props: Record<string, unknown>, propName: string, componentName: string) => Error | null;
        minuteMarksWidth: typeof isHandWidth;
        renderHourMarks: PropTypes.Requireable<boolean>;
        renderMinuteHand: PropTypes.Requireable<boolean>;
        renderMinuteMarks: PropTypes.Requireable<boolean>;
        renderNumbers: PropTypes.Requireable<boolean>;
        renderSecondHand: PropTypes.Requireable<boolean>;
        secondHandLength: (props: Record<string, unknown>, propName: string, componentName: string) => Error | null;
        secondHandOppositeLength: (props: Record<string, unknown>, propName: string, componentName: string) => Error | null;
        secondHandWidth: typeof isHandWidth;
        size: PropTypes.Requireable<NonNullable<string | number | null | undefined>>;
        value: PropTypes.Requireable<NonNullable<string | Date | null | undefined>>;
    };
}
export default Clock;
