"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var React = require("react");
var styles = {
    darkTheme: {
        backgroundColor: '#222222',
        handColor: '#00ff7f',
        tickColor: '#7fffd4'
    },
    lightTheme: {
        backgroundColor: '#ffffff',
        handColor: '#000000',
        tickColor: '#444444'
    }
};
var AnalogClock = function (_a) {
    var hours = _a.hours, displayAm = _a.displayAm, _b = _a.height, height = _b === void 0 ? '100%' : _b, minutes = _a.minutes, seconds = _a.seconds, useDarkTheme = _a.useDarkTheme, _c = _a.width, width = _c === void 0 ? '100%' : _c;
    var imgEl = React.useRef(null);
    var _d = React.useState(false), isTimeSet = _d[0], setTimeSet = _d[1];
    var setInitialHandPosition = React.useCallback(function () {
        var svgEl = imgEl.current;
        if (svgEl === null) {
            React.useEffect(function () {
                setInitialHandPosition();
            });
            return;
        }
        var roundTo6deg = function (deg) {
            return Math.floor(deg / 6) * 6;
        };
        var secondsDeg = roundTo6deg(360 * (seconds / 60));
        var minutesDeg = 360 * ((minutes * 60 + seconds) / 3600);
        var hoursDeg = 360 * ((hours * 3600 + minutes * 60 + seconds) / 43200);
        svgEl.querySelector('.iconic-clock-second-hand').setAttribute('transform', "rotate(".concat(secondsDeg, ",192,192)"));
        svgEl.querySelector('.iconic-clock-minute-hand').setAttribute('transform', "rotate(".concat(minutesDeg, ",192,192)"));
        svgEl.querySelector('.iconic-clock-hour-hand').setAttribute('transform', "rotate(".concat(hoursDeg, ",192,192)"));
        setTimeSet(true);
    }, [hours, minutes, seconds]);
    React.useEffect(function () {
        setInitialHandPosition();
    }, []);
    var theme = useDarkTheme ? styles.darkTheme : styles.lightTheme;
    var renderTicks = function () {
        var color = theme.tickColor;
        var ticks = [];
        for (var i = 0; i < 60; i++) {
            if (i % 15 === 0) {
                ticks.push(React.createElement("line", { x1: "125", y1: "0", x2: "175", y2: "0", strokeWidth: "9", stroke: color, style: { transform: "rotate(".concat(6 * i, "deg)") } }));
            }
            else if (i % 5 === 0) {
                ticks.push(React.createElement("line", { x1: "145", y1: "0", x2: "175", y2: "0", strokeWidth: "6", stroke: color, style: { transform: "rotate(".concat(6 * i, "deg)") } }));
            }
            else {
                ticks.push(React.createElement("line", { x1: "174", y1: "0", x2: "175", y2: "0", strokeWidth: "3", stroke: color, style: { transform: "rotate(".concat(6 * i, "deg)") } }));
            }
        }
        return ticks;
    };
    var stepsHand = function () {
        var steps = [];
        for (var i = 0; i < 60; i++) {
            steps.push("".concat(i * 6, " 192 192"));
        }
        return steps.join(';');
    };
    return (React.createElement("svg", { ref: imgEl, xmlns: "http://www.w3.org/2000/svg", xmlnsXlink: "http://www.w3.org/1999/xlink", x: 0, y: 0, viewBox: "0 0 384 384", preserveAspectRatio: "xMidYMid meet", strokeWidth: 1, strokeLinecap: "round", style: {
            display: isTimeSet ? 'inline-block' : 'none',
            overflow: 'hidden',
            width: width,
            height: height
        } },
        React.createElement("g", { id: "iconic-clock-frame" },
            React.createElement("circle", { r: "190", cx: "192", cy: "192", stroke: "#444444", strokeWidth: "2", fill: theme.backgroundColor }),
            React.createElement("text", { x: "192", y: "220", fill: theme.handColor, dominantBaseline: "middle", textAnchor: "middle", fontFamily: "monospace", fontSize: "120%" }, displayAm ? 'AM' : 'PM')),
        React.createElement("g", { id: "iconic-clock-ticks", transform: "translate(192, 192)" }, renderTicks()),
        React.createElement("line", { className: "iconic-clock-hour-hand", id: "iconic-anim-clock-hour-hand", fill: "none", stroke: theme.handColor, strokeWidth: "10", strokeMiterlimit: "5", x1: "192", y1: "192", x2: "192", y2: "87.5" }),
        React.createElement("line", { className: "iconic-clock-minute-hand", id: "iconic-anim-clock-minute-hand", fill: "none", stroke: theme.handColor, strokeWidth: "6", strokeMiterlimit: "5", x1: "192", y1: "192", x2: "192", y2: "54" }),
        React.createElement("circle", { className: "iconic-clock-axis", cx: "192", cy: "192", r: "9", stroke: theme.handColor }),
        React.createElement("g", { className: "iconic-clock-second-hand", id: "iconic-anim-clock-second-hand" },
            React.createElement("line", { className: "iconic-clock-second-hand-arm", x1: "192", y1: "192", x2: "192", y2: "28.5", fill: "none", stroke: "#D53A1F", strokeWidth: "4", strokeMiterlimit: "10" }),
            React.createElement("circle", { className: "iconic-clock-second-hand-axis", cx: "192", cy: "192", r: "4.5", fill: "#D53A1F", stroke: theme.handColor })),
        React.createElement("defs", null,
            React.createElement("animateTransform", { attributeName: "transform", attributeType: "xml", xlinkHref: "#iconic-anim-clock-hour-hand", type: "rotate", dur: "43200s", from: "0 192 192", to: "360 192 192", fill: "remove", restart: "always", calcMode: "linear", accumulate: "none", additive: "sum", repeatCount: "indefinite" }),
            React.createElement("animateTransform", { attributeName: "transform", attributeType: "xml", xlinkHref: "#iconic-anim-clock-minute-hand", type: "rotate", dur: "3600s", from: "0 192 192", to: "360 192 192", fill: "remove", restart: "always", accumulate: "none", additive: "sum", repeatCount: "indefinite" }),
            React.createElement("animateTransform", { attributeName: "transform", attributeType: "xml", xlinkHref: "#iconic-anim-clock-second-hand", type: "rotate", dur: "60s", from: "0 192 192", to: "360 192 192", calcMode: "discrete", values: stepsHand(), fill: "remove", restart: "always", accumulate: "none", additive: "sum", repeatCount: "indefinite" }))));
};
exports.default = AnalogClock;
//# sourceMappingURL=AnalogClock.js.map