"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var moment = require("moment-timezone");
var React = require("react");
var AnalogClock_1 = require("./AnalogClock");
var styles = {
    container: {
        height: '100%',
        width: '100%',
        textAlign: 'center'
    },
    darkTheme: {
        backgroundColor: '#222222',
        color: '#7fffd4'
    },
    lightTheme: {
        backgroundColor: '#ffffff',
        color: '#000000'
    }
};
var getTheme = function (useDarkTheme, style) {
    if (style === void 0) { style = {}; }
    return (__assign(__assign(__assign({}, styles.container), (useDarkTheme ? styles.darkTheme : styles.lightTheme)), style));
};
var timeoutCall = undefined;
var ThemedAnalogClock = function (_a) {
    var date = _a.date, description = _a.description, size = _a.size, style = _a.style, timezoneName = _a.timezoneName, useDarkTheme = _a.useDarkTheme;
    var _b = React.useMemo(function () {
        var resolvedTimezoneName = timezoneName ? timezoneName : Intl.DateTimeFormat().resolvedOptions().timeZone;
        var dateInTimezone = moment().tz(resolvedTimezoneName);
        var hours = date ? date.getHours() : dateInTimezone.get('hours') % 12;
        var minutes = date ? date.getMinutes() : dateInTimezone.get('minutes');
        var seconds = date ? date.getSeconds() : dateInTimezone.get('seconds');
        var isAm = (date ? date.getHours() : dateInTimezone.get('hours')) < 12;
        return [resolvedTimezoneName, hours, minutes, seconds, isAm];
    }, [date, timezoneName]), resolvedTimezoneName = _b[0], hours = _b[1], minutes = _b[2], seconds = _b[3], isAm = _b[4];
    var _c = React.useState(isAm), displayAm = _c[0], setDisplayAm = _c[1];
    var atEach12 = React.useCallback(function () {
        var now = date ? date : new Date();
        var start = new Date(now.getFullYear(), now.getMonth(), now.getDate(), now.getHours() < 12 ? 12 : 24, 0, 0, 0);
        var wait = start.getTime() - now.getTime();
        if (wait <= 0) {
            atEach12();
            return;
        }
        if (timeoutCall) {
            clearTimeout(timeoutCall);
        }
        timeoutCall = setTimeout(function () {
            var h = date ? (date.getHours() + Math.ceil(wait / 3600000)) % 24 : new Date().getHours();
            setDisplayAm(h < 12);
            atEach12();
        }, wait);
    }, [date]);
    React.useEffect(function () {
        setDisplayAm(isAm);
        atEach12();
        return function () {
            if (timeoutCall) {
                clearTimeout(timeoutCall);
            }
        };
    }, [atEach12, isAm]);
    useDarkTheme = useDarkTheme === true;
    description = description ? description.replace('{}', resolvedTimezoneName) : undefined;
    return (React.createElement("div", { style: getTheme(useDarkTheme, style) },
        React.createElement(AnalogClock_1.default, { hours: hours, minutes: minutes, seconds: seconds, displayAm: displayAm, useDarkTheme: useDarkTheme, width: size, height: getHeight(size, description !== undefined) }),
        React.createElement("div", null, description)));
};
var getHeight = function (size, hasDescription) {
    if (size === undefined) {
        if (hasDescription === false) {
            return undefined;
        }
        return "calc(100% - 1.3em)";
    }
    if (hasDescription === false) {
        return size;
    }
    if (typeof size === 'number') {
        return "calc(".concat(size, "px - 1.3em)");
    }
    return "calc(".concat(size, " - 1.3em)");
};
exports.default = ThemedAnalogClock;
//# sourceMappingURL=ThemedAnalogClock.js.map