# Contributing
You can contribute to this project by simply adding or fixing data in
[countries.json](https://github.com/mledoze/countries/blob/master/countries.json). Before sending your pull request you
can optionally rebuild the files in the `dist` folder using the
[countries.php](https://github.com/mledoze/countries/blob/master/countries.php) script.

# Contributions rules
1. contributions should contain **top-level**, **static** data
2. restrain from sending too detailed, regional or changing countries data like financial or economic data (_e.g._ GDP, population, etc.)
3. to ease the diffs, keep the indentation in the master source file (tabs not spaces), one line for short arrays
4. accented characters must be encoded in unicode
5. all strings must be encoded in UTF-8

# Adding languages
If you are modifying countries languages, please note that you need to provide translation of the countries name on the language that you adding. Example:

Before
```JSON
{
    "name": {
        "common": "Argentina",
        "official": "Argentine Republic",
        "native": {
            "spa": {
                "official": "Rep\u00fablica Argentina",
                "common": "Argentina"
            }
        }
    },
    "...": "...",
    "languages": {
        "spa": "Spanish"
    }
},
```

After
```JSON
{
    "name": {
        "common": "Argentina",
        "official": "Argentine Republic",
        "native": {
            "grn": { //And here...
                "official": "Argentine Republic",
                "common": "Argentina"
            },
            "spa": {
                "official": "Rep\u00fablica Argentina",
                "common": "Argentina"
            }
        }
    },
    "...": "...",
    "languages": {
        "grn": "Guaran\u00ed", //Added here ↑
        "spa": "Spanish"
    }
},
```

# Adding a build script
Countries data is made available in multiple formats (JSON, CSV, XML, etc.) that are generated by the
[countries.php](https://github.com/mledoze/countries/blob/master/countries.php) script; you can either add a conversion
format to it or write it in another language.

### Generate `dist` files
To (re)generate the `dist` files, execute the following commands in the root directory:
```
composer install
php countries.php convert
```
