<?php

$countries = json_decode(file_get_contents('countries.json'), true);

$countries = array_map(static function ($country) {
    if (isset($country['demonyms']) === false && isset($country['demonym'])) {
        $country['demonyms']['eng'] = [
            'f' => $country['demonym'],
            'm' => $country['demonym'],
        ];
        $country['demonyms']['fra'] = [
            'f' => "",
            'm' => "",
        ];

        ksort($country['demonyms']);
        unset($country['demonym']);
    }
    return $country;
}, $countries);

file_put_contents('countries.json', json_encode($countries, JSON_PRETTY_PRINT));