import { Route, Switch } from 'react-router';
import Administrator from './components/Administrator';
import DashBoard from './components/DashBoard';
import Login from './components/Login';
import Maintainance from './components/Maintainance';
import Payments from './components/Payments';
import Transactions from './components/Transactions';
import SendMessages from './components/SendMessages';
import SentMessages from './components/SentMessages';
import BulkSMSAccount from './components/BulkSMSAccount';
import SuperNova from './components/SuperNova';
import Tickets from './components/Tickets';
import Users from './components/Users';
import RouteWithLayout from './components/RouteWithLayout';
import DatabaseUpload from './components/databaseUpload';
import WorldCenter from './components/WorldCenter';
import UserProfile from './components/UserProfile';

const Routes = () => (
  <div>
    <Switch>
      <Route exact path="/" component={Login} />
      <RouteWithLayout
        exact
        component={Administrator}
        layout={DashBoard}
        path="/administrator"
      />
      <RouteWithLayout
        exact
        component={Maintainance}
        layout={DashBoard}
        path="/maintainance"
      />
      <RouteWithLayout
        exact
        component={Payments}
        layout={DashBoard}
        path="/payments"
      />
      <RouteWithLayout
        exact
        component={Transactions}
        layout={DashBoard}
        path="/transactions"
      />
      <RouteWithLayout
        exact
        component={SendMessages}
        layout={DashBoard}
        path="/send-message"
      />
      <RouteWithLayout
        exact
        component={SentMessages}
        layout={DashBoard}
        path="/sent-messages"
      />
      <RouteWithLayout
        exact
        component={BulkSMSAccount}
        layout={DashBoard}
        path="/bulk-sms"
      />
      <RouteWithLayout
        exact
        component={SuperNova}
        layout={DashBoard}
        path="/supernova"
      />
      <RouteWithLayout
        exact
        component={Tickets}
        layout={DashBoard}
        path="/tickets"
      />
      <RouteWithLayout
        exact
        component={DatabaseUpload}
        layout={DashBoard}
        path="/database"
      />
      <RouteWithLayout
        exact
        component={Users}
        layout={DashBoard}
        path="/users"
      />
      <RouteWithLayout
        exact
        component={WorldCenter}
        layout={DashBoard}
        path="/world-center"
      />
      <RouteWithLayout
        exact
        component={UserProfile}
        layout={DashBoard}
        path="/my-profile"
      />
    </Switch>
  </div>
);

export default Routes;
