import { Grid } from '@material-ui/core';
import { makeStyles } from '@material-ui/core/styles';
import React from 'react';
import Lottie from 'react-lottie';
import animationData from '../assets/loading.json';

const useStyles = makeStyles((theme) => ({
  overlay: {
    zIndex: theme.zIndex.drawer + 1,
    position: 'fixed',
    backgroundColor: 'rgba(65, 131, 215, .4)',
    height: '85vh',
    opacity: 0.7,
    width: '80%',
  },
}));

function ActivityIndicator({ visible = false }) {
  const classes = useStyles();

  if (!visible) return null;

  const defaultOptions = {
    loop: true,
    autoplay: true,
    animationData: animationData,
    rendererSettings: {
      preserveAspectRatio: 'xMidYMid slice',
    },
  };

  return (
    <Grid container className={classes.overlay}>
      <Lottie
        options={defaultOptions}
        style={{
          height: 250,
          width: 250,
          marginLeft: '40%',
          marginTop: '20%',
        }}
      />
    </Grid>
  );
}

export default ActivityIndicator;
