import { Button, Grid, TableCell, TableRow } from '@material-ui/core';
import { ListAltOutlined } from '@material-ui/icons';
import React from 'react';
import CustomDatePicker from './CustomDatePicker';
import CustomTable from './CustomTable';
import CustomTabs from './CustomTabs';
import ViewContainer from './ViewContainer';
import { API } from '../config';
import ActivityIndicator from './ActivityIndicator';
import { Skeleton } from '@material-ui/lab';
const moment = require('moment');

const columns = [
  { id: 'DairyPesa', label: 'Company', minWidth: 100 },
  {
    id: 'Trans_Id',
    label: 'Total\u00a0Transactions',
    minWidth: 100,
    format: (value) => value.toLocaleString('en-US'),
  },
  {
    id: 'sum',
    label: 'Total\u00a0Amount',
    minWidth: 100,
    format: (value) => value.toLocaleString('en-US'),
  },
];

function Administrator(props) {
  const today = moment().format('YYYY-MM-DD');
  const [rows, setRows] = React.useState([]);
  const [loading, setLoading] = React.useState(false);
  const [mounting, setMounting] = React.useState(false);
  const [refresh, setRefresh] = React.useState(false);

  React.useEffect(() => {
    const fetchData = async () => {
      setMounting(true);
      const res = await fetch(`${API}/api/dashboard`);
      const json = await res.json();
      setRows(json);
      setMounting(false);
    };
    fetchData();
  }, [refresh]);

  //Filter records
  const filterData = async () => {
    setLoading(true);
    const res = await fetch(`${API}/api/filter/dashboard`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ From: selectedFromDate, To: selectedToDate }),
    });
    const json = await res.json();
    setRows(json);
    setLoading(false);
  };

  const [selectedFromDate, setSelectedFromDate] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );
  const [selectedToDate, setSelectedToDate] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );

  const handleFromDateChange = (date) => {
    setSelectedFromDate(date);
  };

  const handleToDateChange = (date) => {
    setSelectedToDate(date);
  };

  function transactionsCount(items) {
    return items
      .map(({ Trans_Id }) => Trans_Id)
      .reduce((count, i) => count + parseInt(i), 0);
  }

  function sumAmount(items) {
    return items
      .map(({ sum }) => sum)
      .reduce((count, i) => count + parseInt(i), 0);
  }

  const summaryHeaderData = () => {
    return (
      <TableRow style={{ backgroundColor: '#3C8016' }}>
        <TableCell />
        <TableCell />
        <TableCell
          style={{
            fontSize: '10px',
            fontWeight: 'bolder',
            color: 'whitesmoke',
          }}
          colSpan={1}
        >
          Total Transactions{' '}
          {parseInt(transactionsCount(rows)).toLocaleString()}
        </TableCell>
        <TableCell
          style={{
            fontSize: '10px',
            fontWeight: 'bolder',
            color: 'whitesmoke',
          }}
          align="left"
        >
          Total Amount {parseInt(sumAmount(rows)).toLocaleString()}
        </TableCell>
      </TableRow>
    );
  };

  return (
    <>
      <ActivityIndicator visible={loading} />
      <ViewContainer icon={<ListAltOutlined />} title="Summary">
        {mounting ? (
          <>
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />

            <Skeleton
              variant="rect"
              width="100%"
              height={518}
              animation="wave"
            />
          </>
        ) : (
          <>
            <Grid
              container
              spacing={2}
              style={{ display: 'flex', justifyContent: 'flex-end' }}
            >
              <Grid item xs={12} sm={3} md={3}>
                <CustomDatePicker
                  fullWidth
                  selectedDate={selectedFromDate}
                  handleDateChange={handleFromDateChange}
                  label="Select Start Date"
                />
              </Grid>
              <Grid item xs={12} sm={3} md={3}>
                <CustomDatePicker
                  selectedDate={selectedToDate}
                  handleDateChange={handleToDateChange}
                  label="Select End Date"
                />
              </Grid>
              <Grid item xs={12} sm={3} md={2}>
                <Button
                  fullWidth
                  variant="contained"
                  color="primary"
                  style={{ top: '1rem' }}
                  size="medium"
                  onClick={() => setRefresh(!refresh)}
                >
                  Refresh
                </Button>
              </Grid>
              <Grid item xs={12} sm={3} md={2}>
                <Button
                  fullWidth
                  variant="contained"
                  color="primary"
                  style={{ top: '1rem', marginBottom: 20 }}
                  size="medium"
                  onClick={filterData}
                >
                  Filter
                </Button>
              </Grid>
            </Grid>
            <Grid container spacing={2}>
              <Grid item xs={12}>
                <CustomTable
                  rows={rows}
                  columns={columns}
                  summaryHeader={true}
                  summaryHeaderData={summaryHeaderData()}
                  rowCount={true}
                />
              </Grid>
              <Grid item xs={12}>
                <CustomTabs />
              </Grid>
            </Grid>
          </>
        )}
      </ViewContainer>
    </>
  );
}

export default Administrator;
