import {
  Button,
  Card,
  CardHeader,
  CircularProgress,
  Grid,
  Typography,
} from '@material-ui/core';
import {
  DataUsage,
  GetAppRounded,
  RotateRightRounded,
  ScreenShareRounded,
  SmsOutlined,
} from '@material-ui/icons';
import React from 'react';
import { Pie } from 'react-chartjs-2';
import CustomDatePicker from './CustomDatePicker';
import CustomDropDown from './CustomDropDown';
import CustomInputField from './CustomInputField';
import ViewContainer from './ViewContainer';
import CustomTable from './CustomTable';
import { API } from '../config';
import CustomSnackBar from './CustomSnackBar';
import { isAuthenticated } from '../API';
const moment = require('moment');

const columns = [
  { id: 'ID', label: 'ID', minWidth: 50 },
  { id: 'Date', label: 'Date', minWidth: 100 },
  {
    id: 'Bulk_Before',
    label: 'Bulk\u00a0Before',
    minWidth: 100,
    format: (value) => value.toLocaleString('en-US'),
  },
  {
    id: 'Bulk_Count',
    label: 'Bulk\u00a0Count',
    minWidth: 100,
    format: (value) => value.toLocaleString('en-US'),
  },
  {
    id: 'Bulk_Type',
    label: 'Platform',
    minWidth: 100,
    format: (value) => value.toLocaleString('en-US'),
  },
  {
    id: 'Bulk_Balance',
    label: 'Bulk\u00a0Balance',
    minWidth: 100,
    format: (value) => value.toLocaleString('en-US'),
  },
  {
    id: 'Bulk_Status',
    label: 'Status',
    minWidth: 100,
    format: (value) => value.toLocaleString('en-US'),
  },
];

function BulkSMSAccount(props) {
  const today = moment().format('YYYY-MM-DD');
  const { mobile } = isAuthenticated();

  const [rows, setRows] = React.useState([]);
  const [bulkUSageSummary, setBulkUSageSummary] = React.useState(0);
  const [bulkSummary, setBulkSummary] = React.useState();
  const [companyIDMapping, setCompanyIDMapping] = React.useState();
  const [loading, setLoading] = React.useState(false);
  const [OTPLoading, setOTPLoading] = React.useState(false);
  const [bulkTransferLoading, setBulkTransferLoading] = React.useState(false);
  const [bulkTransferOTP, setBulkTransferOTP] = React.useState('');
  const [bulkTransferAmount, setBulkTransferAmount] = React.useState(0);
  const [bulkAmount, setBulkAmount] = React.useState(0);
  const [mounting, setMounting] = React.useState(false);
  const [refresh, setRefresh] = React.useState(false);

  const [openAlert, setOpenAlert] = React.useState(false);
  const [alertMessage, setAlertMessage] = React.useState('');
  const [error, setError] = React.useState(false);

  const [platform, setPlatForm] = React.useState(1);
  const [filterBulkPlatform, setFilterBulkPlatform] = React.useState(1);
  const [phoneNumber, setPhoneNumber] = React.useState('');
  const [bulkFilterCount, setBulkFilterCount] = React.useState();
  const [selectedFromDate, setSelectedFromDate] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );
  const [selectedToDate, setSelectedToDate] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );

  const handleAlertClose = (event, reason) => {
    if (reason === 'clickaway') {
      return;
    }

    setOpenAlert(false);
  };

  //Get OTP Code
  const getOTPCode = async () => {
    setOTPLoading(true);
    const res = await fetch(`${API}/api/request-auth-otp`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ mobile: mobile }),
    });
    const json = await res.json();
    setOTPLoading(false);

    if (!json.message) {
      setError(true);
      setAlertMessage(json.error);
      setOpenAlert(true);
    } else {
      setError(false);
      setAlertMessage(json.message);
      setOpenAlert(true);
    }
  };

  //Transfer Bulk
  const transferBulk = async () => {
    setBulkTransferLoading(true);
    const res = await fetch(`${API}/api/bulk-transfer-request`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({
        mobile: mobile,
        amount: bulkTransferAmount,
        OTP: bulkTransferOTP,
      }),
    });
    const json = await res.json();
    setBulkTransferLoading(false);

    if (!json.message) {
      setError(true);
      setAlertMessage(json.error);
      setOpenAlert(true);
      setRefresh(!refresh);
    } else {
      setError(false);
      setAlertMessage(json.message);
      setOpenAlert(true);
      setBulkTransferAmount('');
      setBulkTransferOTP('');
    }
  };

  console.log(bulkSummary);
  React.useEffect(() => {
    const fetchData = async () => {
      setMounting(true);
      const res = await fetch(`${API}/api/bulk-usage`);
      const json = await res.json();
      setRows(json);
      setMounting(false);
    };
    fetchData();
  }, [refresh]);

  React.useEffect(() => {
    const fetchData = async () => {
      setMounting(true);
      const res = await fetch(`${API}/api/bulk-summary`);
      const json = await res.json();
      setBulkSummary(json);
      setMounting(false);
    };
    fetchData();
  }, [refresh]);

  React.useEffect(() => {
    const fetchData = async () => {
      setMounting(true);
      const res = await fetch(`${API}/api/bulk-usage-summary`);
      const json = await res.json();
      setBulkUSageSummary(json);
      setMounting(false);
    };
    fetchData();
  }, [refresh]);

  React.useEffect(() => {
    const fetchData = async () => {
      setMounting(true);
      const res = await fetch(`${API}/api/company-ID-mappings`, {
        method: 'POST', // or 'PUT'
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ mobile }),
      });
      const json = await res.json();
      setCompanyIDMapping(json);
      setMounting(false);
    };
    fetchData();
  }, []);

  React.useEffect(() => {
    const fetchData = async () => {
      setMounting(true);
      const res = await fetch(`${API}/api/bulk-balance`);
      const json = await res.json();
      setBulkAmount(json[0].Amount);
      console.log(json);
      setMounting(false);
    };
    fetchData();
  }, []);

  //Filter Bulk Usage
  const bulkUsageFilter = async () => {
    setLoading(true);
    const res = await fetch(`${API}/api/filter-bulk-usage`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({
        company: platform,
      }),
    });
    const json = await res.json();
    setRows(json);
    setLoading(false);
  };

  //Filter records
  const bulkFilter = async () => {
    setLoading(true);
    const res = await fetch(`${API}/api/bulk-filter`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({
        company: filterBulkPlatform,
        From: selectedFromDate,
        To: selectedToDate,
      }),
    });
    const json = await res.json();
    setBulkFilterCount(json);
    setLoading(false);
  };

  const handleFilterBulkDropDownChange = (event) => {
    setFilterBulkPlatform(event.target.value);
  };

  const handleDropDownChange = (event) => {
    setPlatForm(event.target.value);
    bulkUsageFilter();
  };

  const handleBulkTransferOTPInputFieldChange = (e) => {
    setBulkTransferOTP(e.target.value);
  };

  const handleBulkTransferAmountInputFieldChange = (e) => {
    setBulkTransferAmount(e.target.value);
  };

  const handleInputFieldChange = (e) => {
    setPhoneNumber(e.target.value);
  };

  const handleFromDateChange = (date) => {
    setSelectedFromDate(date);
  };

  const handleToDateChange = (date) => {
    setSelectedToDate(date);
  };

  const graphData = {
    labels: ['Bulk Bought', 'Bulk Remaining'],
    datasets: [
      {
        label: '# of Votes',
        data: [
          bulkSummary && bulkSummary[0].After_Amount,
          bulkSummary && bulkSummary[0].smsbal,
        ],
        backgroundColor: ['rgba(60, 179, 113, 0.8)', 'rgba(255, 0, 0, 0.8)'],
        borderColor: ['rgba(60, 179, 113, 1)', 'rgba(255, 0, 0, 1)'],
        borderWidth: 1,
      },
    ],
  };
  return (
    <>
      <ViewContainer icon={<SmsOutlined />} title="Bulk Summary">
        <Grid container spacing={2}>
          <Grid container item spacing={2}>
            <Grid item xs={12} md={4}>
              <Card
                style={{
                  width: '100%',
                  maxHeight: '100%',
                  backgroundColor: '#FFDEAD',
                }}
                elevation={5}
              >
                <CardHeader
                  title="Bulk Summary"
                  style={{ textAlign: 'center', fontSize: '2px' }}
                />
                <Pie data={graphData} />
              </Card>
            </Grid>
            <Grid container item xs={12} md={8}>
              <Grid item xs={12} style={{ marginBottom: '10px' }}>
                <Card
                  style={{
                    width: '100%',
                    height: '100%',
                    backgroundColor: '#EADDCA',
                  }}
                  elevation={5}
                >
                  {/* <CardHeader
                  title="Bulk Filter"
                  style={{ textAlign: 'center', fontSize: '2px' }}
                /> */}
                  <Typography style={{ textAlign: 'center' }}>
                    Bulk Filter
                  </Typography>
                  <Grid container spacing={2}>
                    <Grid
                      container
                      item
                      spacing={2}
                      style={{ display: 'flex', justifyContent: 'center' }}
                    >
                      <Grid item>
                        <CustomDatePicker
                          selectedDate={selectedFromDate}
                          handleDateChange={handleFromDateChange}
                          label="Select Start Date"
                        />
                      </Grid>
                      <Grid item>
                        <CustomDatePicker
                          selectedDate={selectedFromDate}
                          handleDateChange={handleToDateChange}
                          label="Select End Date"
                        />
                      </Grid>
                      <Grid item>
                        <Button
                          variant="contained"
                          style={{ top: '1rem' }}
                          color="primary"
                        >
                          Bulk Used{' '}
                          <span style={{ color: '#EE4B2B', marginLeft: 10 }}>
                            {bulkFilterCount
                              ? bulkFilterCount[0].Bulk_Count
                              : 0}
                          </span>
                        </Button>
                      </Grid>
                    </Grid>
                    <Grid
                      container
                      item
                      spacing={2}
                      style={{ display: 'flex', justifyContent: 'center' }}
                    >
                      <Grid item>
                        <CustomDropDown
                          variant="outlined"
                          size="small"
                          // label="Select PlatForm"
                          style={{
                            top: '1rem',
                            marginRight: '10px',
                            width: '10rem',
                          }}
                          selectedValue={filterBulkPlatform}
                          handleChange={handleFilterBulkDropDownChange}
                          data={companyIDMapping}
                        />
                      </Grid>
                      <Grid item>
                        <Button
                          variant="contained"
                          style={{ top: '1rem' }}
                          color="primary"
                          fullWidth
                          onClick={bulkFilter}
                          startIcon={
                            loading ? (
                              <CircularProgress
                                size={20}
                                style={{ marginRight: 20, color: '#fff' }}
                              />
                            ) : (
                              <RotateRightRounded />
                            )
                          }
                        >
                          Filter Bulk
                        </Button>
                      </Grid>
                    </Grid>
                  </Grid>
                </Card>
              </Grid>
              <Grid item xs={12}>
                <Card
                  style={{
                    width: '100%',
                    height: '100%',
                    backgroundColor: '#F5DEB3	',
                  }}
                  elevation={5}
                >
                  <Typography style={{ textAlign: 'center' }}>
                    Bulk Transfer
                  </Typography>
                  <Grid container spacing={2}>
                    <Grid
                      container
                      item
                      spacing={2}
                      style={{ display: 'flex', justifyContent: 'center' }}
                    >
                      <Grid item>
                        <Button
                          variant="contained"
                          style={{ top: '1rem' }}
                          color="primary"
                        >
                          Balance{' '}
                          <span style={{ color: 'red', marginLeft: 10 }}>
                            {bulkAmount}
                          </span>
                        </Button>
                      </Grid>
                      <Grid item>
                        <CustomInputField
                          label="Enter Amount"
                          variant="outlined"
                          size="small"
                          placeholder="Enter Amount"
                          style={{ top: '1rem' }}
                          onChange={handleBulkTransferAmountInputFieldChange}
                          // onKeyDown={searchDataOnEnter}
                        />
                      </Grid>
                      <Grid item>
                        <CustomInputField
                          label="Enter OTP Code"
                          variant="outlined"
                          size="small"
                          placeholder="Enter OTP Code"
                          style={{ top: '1rem' }}
                          onChange={handleBulkTransferOTPInputFieldChange}
                          // onKeyDown={searchDataOnEnter}
                        />
                      </Grid>
                    </Grid>
                    <Grid
                      container
                      item
                      spacing={2}
                      style={{ display: 'flex', justifyContent: 'center' }}
                    >
                      <Grid item>
                        <Button
                          variant="contained"
                          style={{ top: '1rem' }}
                          color="primary"
                          fullWidth
                          startIcon={
                            OTPLoading ? (
                              <CircularProgress
                                size={20}
                                style={{ marginRight: 20, color: '#fff' }}
                              />
                            ) : (
                              <GetAppRounded />
                            )
                          }
                          onClick={getOTPCode}
                        >
                          Get OTP
                        </Button>
                      </Grid>
                      <Grid item>
                        <Button
                          variant="contained"
                          style={{ top: '1rem' }}
                          color="primary"
                          fullWidth
                          onClick={transferBulk}
                          startIcon={
                            bulkTransferLoading ? (
                              <CircularProgress
                                size={20}
                                style={{ marginRight: 20, color: '#fff' }}
                              />
                            ) : (
                              <ScreenShareRounded />
                            )
                          }
                        >
                          Transfer Bulk
                        </Button>
                      </Grid>
                    </Grid>
                  </Grid>
                </Card>
              </Grid>
            </Grid>
          </Grid>
          <Grid item xs={12}>
            <Card style={{ width: '100%', minHeight: 100 }}>
              <ViewContainer icon={<DataUsage />} title="Bulk Usage">
                <Grid container>
                  <Grid
                    container
                    item
                    style={{
                      display: 'flex',
                      justifyContent: 'space-between',
                      marginBottom: 10,
                    }}
                  >
                    <Grid item>
                      <CustomDropDown
                        variant="outlined"
                        size="small"
                        // label="Select PlatForm"
                        style={{
                          // top: '1rem',
                          marginRight: '10px',
                          width: '10rem',
                        }}
                        selectedValue={platform}
                        handleChange={handleDropDownChange}
                        data={companyIDMapping}
                      />
                    </Grid>
                    <Grid item>
                      <Button variant="contained" color="primary">
                        Total Bulk:{' '}
                        {bulkUSageSummary && bulkUSageSummary[0].Total_Bulk} -
                        Amount: {bulkUSageSummary && bulkUSageSummary[0].Amount}
                      </Button>
                    </Grid>
                    <Grid item>
                      <Button
                        variant="contained"
                        color="primary"
                        onClick={() => setRefresh(!refresh)}
                      >
                        Refresh
                      </Button>
                    </Grid>
                  </Grid>
                  <Grid item xs={12}>
                    <CustomTable rows={rows} columns={columns} />
                  </Grid>
                </Grid>
              </ViewContainer>
            </Card>
          </Grid>
        </Grid>
      </ViewContainer>
      <CustomSnackBar
        vertical="top"
        horizontal="center"
        severity={error ? 'error' : 'success'}
        open={openAlert}
        handleClose={handleAlertClose}
        hideDuration={6000}
        message={alertMessage}
      />
    </>
  );
}

export default BulkSMSAccount;
