import { Backdrop, CircularProgress } from '@material-ui/core';
import { makeStyles } from '@material-ui/styles';
import React from 'react';

const useStyles = makeStyles((theme) => ({
  backdrop: {
    zIndex: -1,
    color: '#fff',
  },
}));

function CustomBackDrop({ openBackDrop, handleBackDropOnclick }) {
  const classes = useStyles();

  return (
    <Backdrop
      className={classes.backdrop}
      open={openBackDrop}
      onClick={handleBackDropOnclick}
    >
      <CircularProgress color="inherit" />
    </Backdrop>
  );
}

export default CustomBackDrop;
