import React from 'react';
import 'date-fns';
import Grid from '@material-ui/core/Grid';
import DateFnsUtils from '@date-io/date-fns';
import {
  MuiPickersUtilsProvider,
  KeyboardDatePicker,
} from '@material-ui/pickers';

function CustomDatePicker({ selectedDate, handleDateChange, label }) {
  return (
    <MuiPickersUtilsProvider utils={DateFnsUtils}>
      <Grid container justifyContent="space-around">
        <KeyboardDatePicker
          disableToolbar
          variant="dialog"
          inputVariant="outlined"
          format="yyyy-MM-dd"
          margin="normal"
          id="date-picker-inline"
          label={label}
          value={selectedDate}
          onChange={handleDateChange}
          KeyboardButtonProps={{
            'aria-label': 'change date',
          }}
          style={{ width: '11rem' }}
          size="small"
        />
      </Grid>
    </MuiPickersUtilsProvider>
  );
}

export default CustomDatePicker;
