import React from 'react';
import SnoozeIcon from '@material-ui/icons/Snooze';
import AlarmIcon from '@material-ui/icons/AddAlarm';
import { IconButton, InputAdornment } from '@material-ui/core';
import DateFnsUtils from '@date-io/date-fns';
import { DateTimePicker, MuiPickersUtilsProvider } from '@material-ui/pickers';

function CustomDateTimePicker({
  helperText,
  selectedDate,
  handleDateTimeChange,
}) {
  return (
    <MuiPickersUtilsProvider utils={DateFnsUtils}>
      <DateTimePicker
        autoOk
        hideTabs
        variant="dialog"
        ampm={false}
        value={selectedDate}
        onChange={handleDateTimeChange}
        inputVariant="outlined"
        allowKeyboardControl={false}
        format="yyyy-MM-dd HH:mm"
        helperText={helperText}
        leftArrowIcon={<AlarmIcon />}
        leftArrowButtonProps={{ 'aria-label': 'Prev month' }}
        rightArrowButtonProps={{ 'aria-label': 'Next month' }}
        rightArrowIcon={<SnoozeIcon />}
        size="small"
        InputProps={{
          endAdornment: (
            <InputAdornment position="end">
              <IconButton>
                <AlarmIcon />
              </IconButton>
            </InputAdornment>
          ),
        }}
      />
    </MuiPickersUtilsProvider>
  );
}

export default CustomDateTimePicker;
