import { TextField } from '@material-ui/core';
import React from 'react';

function CustomDropDown({ selectedValue, handleChange, data, ...restProps }) {
  return (
    <TextField
      id="outlined-select-currency-native"
      select
      value={selectedValue}
      onChange={handleChange}
      SelectProps={{
        native: true,
      }}
      {...restProps}
    >
      {data &&
        data.map((option) => (
          <option key={option.value} value={option.value}>
            {option.label}
          </option>
        ))}
    </TextField>
  );
}

export default CustomDropDown;
