import {
  Dialog,
  DialogContent,
  DialogTitle,
  Grid,
  IconButton,
  makeStyles,
  Typography,
} from '@material-ui/core';
import React from 'react';
import CloseIcon from '@material-ui/icons/Close';
import Slide from '@material-ui/core/Slide';

const Transition = React.forwardRef(function Transition(props, ref) {
  return <Slide direction="left" ref={ref} {...props} />;
});

const useStyles = makeStyles((theme) => ({
  dialogWrapper: {
    padding: theme.spacing(2),
    position: 'absolute',
    top: theme.spacing(2),
    maxWidth: '50%',
  },
  dialogTittle: {
    marginLeft: 0,
    color: '#3C8016',
  },
  closeBtn: {
    top: 0,
    marginTop: 0,
    paddingTop: 0,
    marginLeft: 0,
    height: 10,
    width: 10,
  },
  button: {
    '&:hover': {
      backgroundColor: '#3C8016',
      color: 'white',
    },
  },
}));

const CustomModal = (props) => {
  const { title, children, openPopup, setOpenPopup } = props;

  const classes = useStyles();

  return (
    <Dialog
      open={openPopup}
      maxWidth="lg"
      classes={{ paper: classes.dialogWrapper }}
    >
      <DialogTitle
        className={classes.dialogTittle}
        TransitionComponent={Transition}
      >
        <Grid
          container
          spacing={2}
          style={{
            display: 'flex',
            justifyContent: 'space-between',
            top: 0,
          }}
        >
          <Grid item>
            <Typography variant="h6">{title}</Typography>
          </Grid>
          <Grid item>
            <IconButton
              onClick={() => {
                setOpenPopup(false);
              }}
              aria-label="delete"
              color="#3C8016"
              className={classes.button}
              size="small"
            >
              <CloseIcon fontSize="small" />
            </IconButton>
          </Grid>
        </Grid>
        {/* <div style={{ display: 'flex' }}></div> */}
      </DialogTitle>
      <DialogContent dividers>{children}</DialogContent>
    </Dialog>
  );
};

export default CustomModal;
