import React from 'react';
import { TextField, Button, Grid } from '@material-ui/core';
import { API } from '../../config';
import { useFormik } from 'formik';
const _ = require('lodash');

const AddPlatformAccount = ({
  setOpenPopup,
  setLoading,
  setOpenAlert,
  setError,
  setAlertMessage,
  setRefresh,
  refresh,
}) => {
  const initialValues = {
    Company: '',
    Paybill: '',
    Bank: '',
    Account: '',
  };

  const onSubmit = (values) => {
    const company = values.Company;
    const paybill = values.Paybill;
    const bank = values.Bank;
    const account = values.Account;

    //Add record
    const insertData = async () => {
      setLoading(true);
      const res = await fetch(`${API}/api/add-platform-account`, {
        method: 'POST', // or 'PUT'
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ company, paybill, bank, account }),
      });
      setLoading(false);
      const json = await res.json();
      if (!json.message) {
        setError(true);
        setAlertMessage('Error Add Platform Account');
        setOpenAlert(true);
      } else {
        setError(false);
        setAlertMessage(json.message);
        setOpenAlert(true);
      }
    };
    insertData();
    setRefresh(!refresh);
  };

  const validate = (values) => {
    let errors = {};

    if (!values.Company) {
      errors.Company = 'Company is Required';
    }

    if (!values.Paybill) {
      errors.Paybill = 'Paybill is Required';
    }

    if (!values.Bank) {
      errors.Bank = 'Bank is Required';
    }

    if (!values.Account) {
      errors.Account = 'AccountNo is Required';
    }

    return errors;
  };

  const formik = useFormik({
    initialValues,
    onSubmit,
    validate,
  });

  return (
    <>
      <form noValidate autoComplete="off" onSubmit={formik.handleSubmit}>
        <Grid container spacing={2}>
          <Grid item xs={12}>
            <TextField
              fullWidth
              required
              id="Company"
              label="Enter Company Name"
              onChange={formik.handleChange}
              onBlur={formik.handleBlur}
              value={formik.values.Company}
              helperText={
                formik.touched.Company && formik.errors.Company ? (
                  <span>{formik.errors.Company}</span>
                ) : null
              }
              error={
                formik.touched.Company &&
                Boolean(formik.errors.Company) &&
                formik.errors.Company ? (
                  <div>{formik.errors.Company}</div>
                ) : null
              }
            />
          </Grid>
          <Grid item xs={12}>
            <TextField
              fullWidth
              required
              id="Paybill"
              label="Enter Paybill Number"
              onChange={formik.handleChange}
              onBlur={formik.handleBlur}
              value={formik.values.Paybill}
              helperText={
                formik.touched.Paybill && formik.errors.Paybill ? (
                  <span>{formik.errors.Paybill}</span>
                ) : null
              }
              error={
                formik.touched.Paybill &&
                Boolean(formik.errors.Paybill) &&
                formik.errors.Paybill ? (
                  <div>{formik.errors.Paybill}</div>
                ) : null
              }
            />
          </Grid>
          <Grid item xs={12}>
            <TextField
              fullWidth
              required
              id="Bank"
              label="Enter Bank Name"
              onChange={formik.handleChange}
              onBlur={formik.handleBlur}
              value={formik.values.Bank}
              helperText={
                formik.touched.Bank && formik.errors.Bank ? (
                  <span>{formik.errors.Bank}</span>
                ) : null
              }
              error={
                formik.touched.Bank &&
                Boolean(formik.errors.Bank) &&
                formik.errors.Bank ? (
                  <div>{formik.errors.Bank}</div>
                ) : null
              }
            />
          </Grid>
          <Grid item xs={12}>
            <TextField
              fullWidth
              required
              id="Account"
              label="Enter Acount Number"
              onChange={formik.handleChange}
              onBlur={formik.handleBlur}
              value={formik.values.Account}
              helperText={
                formik.touched.Account && formik.errors.Account ? (
                  <span>{formik.errors.Account}</span>
                ) : null
              }
              error={
                formik.touched.Account &&
                Boolean(formik.errors.Account) &&
                formik.errors.Account ? (
                  <div>{formik.errors.Account}</div>
                ) : null
              }
            />
          </Grid>
          <Grid item xs={12}>
            <Button
              type="submit"
              disabled={_.isEmpty(formik.errors) !== true}
              onClick={() => setOpenPopup(false)}
              fullWidth
              variant="contained"
              color="primary"
              style={{ marginTop: 20 }}
            >
              Save Platform Account
            </Button>
          </Grid>
        </Grid>
      </form>
    </>
  );
};

export default AddPlatformAccount;
