import React, { useState } from 'react';
import { makeStyles } from '@material-ui/core/styles';
import {
  TextField,
  Button,
  Grid,
  FormGroup,
  FormControlLabel,
  Checkbox,
  Typography,
  InputAdornment,
  IconButton,
  OutlinedInput,
  FormControl,
  InputLabel,
} from '@material-ui/core';
import { API } from '../../config';
import { useFormik } from 'formik';
import CustomDropDown from '../CustomDropDown';
import { green } from '@material-ui/core/colors';
import { withStyles } from '@material-ui/styles';
import CustomSnackBar from '../CustomSnackBar';
import { Visibility, VisibilityOff } from '@material-ui/icons';
const _ = require('lodash');

const GreenCheckbox = withStyles({
  root: {
    color: green[400],
    '&$checked': {
      color: green[600],
    },
  },
  checked: {},
})((props) => <Checkbox color="default" {...props} />);

const useStyles = makeStyles((theme) => ({
  // input: {
  //   width: '75ch',
  // },
  // button: {
  //   margin: theme.spacing(2),
  // },
}));

const systemRoles = [
  {
    value: '1',
    label: 'Admin',
  },
  {
    value: '3',
    label: 'Operator',
  },
  {
    value: '2',
    label: 'Promoter',
  },
];

const AddSystemOperator = ({ setOpenPopup, setRefresh, refresh }) => {
  const classes = useStyles();
  const [roles, setRoles] = React.useState('1');
  const [mounting, setMounting] = React.useState(false);
  const [loading, setLoading] = React.useState(false);
  const [showPassword, setShowPassword] = React.useState(false);
  const [error, setError] = React.useState(false);
  const [alertMessage, setAlertMessage] = React.useState('');
  const [openAlert, setOpenAlert] = React.useState(false);
  const [companyIDMapping, setCompanyIDMapping] = React.useState();

  const [state, setState] = React.useState({});
  console.log(state);
  const filteredByValue = Object.fromEntries(
    Object.entries(state).filter(([key, value]) => value === true)
  );
  console.log(filteredByValue);

  let platforms = Object.keys(filteredByValue).join('#');

  // console.log(platforms);
  const handleChange = (event) => {
    setState({ ...state, [event.target.name]: event.target.checked });
  };

  React.useEffect(() => {
    const fetchData = async () => {
      setMounting(true);
      const res = await fetch(`${API}/api/company-ids`);
      const json = await res.json();
      setCompanyIDMapping(json);
      setMounting(false);
    };
    fetchData();
  }, []);

  const handleClickShowPassword = () => {
    setShowPassword(!showPassword);
  };

  const handleMouseDownPassword = (event) => {
    event.preventDefault();
  };

  const handleDropDownChange = (event) => {
    setRoles(event.target.value);
  };

  const handleAlertClose = (event, reason) => {
    if (reason === 'clickaway') {
      return;
    }

    setOpenAlert(false);
  };

  const initialValues = {
    firstName: '',
    lastName: '',
    mobileNo: '',
    email: '',
    roles: roles,
  };

  const onSubmit = (values) => {
    const firstname = values.firstName;
    const lastname = values.lastName;
    const mobileno = values.mobileNo;
    const email = values.email;
    const password = values.password;
    const role = values.role;

    //Add record
    const insertData = async () => {
      setLoading(true);
      const res = await fetch(`${API}/api/add-system-user`, {
        method: 'POST', // or 'PUT'
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({
          firstName: firstname,
          lastName: lastname,
          mobile: mobileno,
          email: email,
          role: role,
          platforms: platforms,
        }),
      });
      setLoading(false);
      const json = await res.json();
      if (!json.message) {
        setError(true);
        setAlertMessage('Error Adding User');
        setOpenAlert(true);
      } else {
        setError(false);
        setAlertMessage(json.message);
        setOpenAlert(true);
      }
    };
    insertData();
    setRefresh(!refresh);
  };

  const validate = (values) => {
    let errors = {};

    if (!values.firstName) {
      errors.firstName = 'FirstName is Required';
    }

    if (!values.lastName) {
      errors.lastName = 'LastName is Required';
    }

    if (!values.mobileNo) {
      errors.mobileNo = 'Mobile Number is Required';
    }

    if (!values.password) {
      errors.password = 'User password is Required';
    }

    if (!values.email) {
      errors.email = 'Email is Required';
    } else if (!/^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i.test(values.email)) {
      errors.email = 'Invalid email address';
    }

    if (!values.role) {
      errors.role = 'Role is Required';
    }

    return errors;
  };

  const formik = useFormik({
    initialValues,
    onSubmit,
    validate,
  });

  return (
    <>
      <form autoComplete="off" onSubmit={formik.handleSubmit}>
        <Grid container spacing={2}>
          <Grid item xs={12}>
            <TextField
              fullWidth
              required
              className={classes.input}
              id="firstName"
              label="First Name"
              onChange={formik.handleChange}
              onBlur={formik.handleBlur}
              value={formik.values.firstName}
              helperText={
                formik.touched.firstName && formik.errors.firstName ? (
                  <span>{formik.errors.firstName}</span>
                ) : null
              }
              error={
                formik.touched.firstName &&
                Boolean(formik.errors.firstName) &&
                formik.errors.firstName ? (
                  <div>{formik.errors.firstName}</div>
                ) : null
              }
            />
          </Grid>
          <Grid item xs={12}>
            <TextField
              fullWidth
              required
              className={classes.input}
              id="lastName"
              label="Last Name"
              onChange={formik.handleChange}
              onBlur={formik.handleBlur}
              value={formik.values.lastName}
              helperText={
                formik.touched.lastName && formik.errors.lastName ? (
                  <span>{formik.errors.lastName}</span>
                ) : null
              }
              error={
                formik.touched.lastName &&
                Boolean(formik.errors.lastName) &&
                formik.errors.lastName ? (
                  <div>{formik.errors.lastName}</div>
                ) : null
              }
            />
          </Grid>
          <Grid item xs={12}>
            <TextField
              fullWidth
              required
              className={classes.input}
              id="mobileNo"
              label="Mobile Number"
              onChange={formik.handleChange}
              onBlur={formik.handleBlur}
              value={formik.values.mobileNo}
              helperText={
                formik.touched.mobileNo && formik.errors.mobileNo ? (
                  <span>{formik.errors.mobileNo}</span>
                ) : null
              }
              error={
                formik.touched.mobileNo &&
                Boolean(formik.errors.mobileNo) &&
                formik.errors.mobileNo ? (
                  <div>{formik.errors.mobileNo}</div>
                ) : null
              }
            />
          </Grid>
          <Grid item xs={12}>
            <TextField
              fullWidth
              required
              className={classes.input}
              id="email"
              label="Email"
              type="email"
              onChange={formik.handleChange}
              onBlur={formik.handleBlur}
              value={formik.values.email}
              helperText={
                formik.touched.email && formik.errors.email ? (
                  <span>{formik.errors.email}</span>
                ) : null
              }
              error={
                formik.touched.email &&
                Boolean(formik.errors.email) &&
                formik.errors.email ? (
                  <div>{formik.errors.email}</div>
                ) : null
              }
            />
          </Grid>
          <Grid item xs={12}>
            <FormControl variant="standard" fullWidth>
              <InputLabel htmlFor="outlined-adornment-password">
                Password
              </InputLabel>
              <OutlinedInput
                fullWidth
                required
                className={classes.input}
                id="password"
                label="password"
                inputProps={{
                  autocomplete: 'new-password',
                  form: {
                    autocomplete: 'off',
                  },
                }}
                type={showPassword ? 'text' : 'password'}
                onChange={formik.handleChange}
                onBlur={formik.handleBlur}
                value={formik.values.password}
                helperText={
                  formik.touched.password && formik.errors.password ? (
                    <span>{formik.errors.password}</span>
                  ) : null
                }
                error={
                  formik.touched.password &&
                  Boolean(formik.errors.password) &&
                  formik.errors.password ? (
                    <div>{formik.errors.password}</div>
                  ) : null
                }
                endAdornment={
                  <InputAdornment position="end">
                    <IconButton
                      aria-label="toggle password visibility"
                      onClick={handleClickShowPassword}
                      onMouseDown={handleMouseDownPassword}
                      edge="end"
                    >
                      {showPassword ? <VisibilityOff /> : <Visibility />}
                    </IconButton>
                  </InputAdornment>
                }
              />
            </FormControl>
          </Grid>
          <Grid item xs={12}>
            <CustomDropDown
              fullWidth
              variant="outlined"
              size="small"
              label="Select Role"
              style={{ marginTop: 10, marginBottom: 10 }}
              selectedValue={roles}
              handleChange={handleDropDownChange}
              data={systemRoles}
              required
              // className={classes.input}
              id="role"
              onChange={formik.handleChange}
              onBlur={formik.handleBlur}
              value={formik.values.role}
              helperText={
                formik.touched.role && formik.errors.role ? (
                  <span>{formik.errors.role}</span>
                ) : null
              }
              error={
                formik.touched.role &&
                Boolean(formik.errors.role) &&
                formik.errors.role ? (
                  <div>{formik.errors.role}</div>
                ) : null
              }
            />
          </Grid>
          <Grid item xs={12}>
            <Typography align="center" variant="h6">
              Select Platforms To Access
            </Typography>
            <FormGroup row>
              {/* <FormControlLabel
              control={<GreenCheckbox />}
              label="Grant Access to All"
            /> */}
              {companyIDMapping &&
                companyIDMapping.map((company) => (
                  <FormControlLabel
                    control={
                      <GreenCheckbox
                        // checked={name.includes(`${company.value}`)}
                        name={company.value}
                        onChange={handleChange}
                      />
                    }
                    label={company.label}
                  />
                ))}
            </FormGroup>
          </Grid>
          <Grid item xs={12}>
            <Button
              type="submit"
              onClick={() => {
                _.isEmpty(formik.errors) && setOpenPopup(false);
              }}
              fullWidth
              variant="contained"
              color="primary"
              style={{ marginTop: 20 }}
            >
              Save User
            </Button>
          </Grid>
        </Grid>
      </form>
      <CustomSnackBar
        vertical="top"
        horizontal="right"
        severity={error ? 'error' : 'success'}
        open={openAlert}
        handleClose={handleAlertClose}
        hideDuration={6000}
        message={alertMessage}
      />
    </>
  );
};

export default AddSystemOperator;
