import React from 'react';
import { makeStyles } from '@material-ui/core/styles';
import { green } from '@material-ui/core/colors';
import {
  TextField,
  Button,
  Grid,
  Typography,
  FormGroup,
  FormControlLabel,
  Checkbox,
} from '@material-ui/core';
import { API } from '../../config';
import { useFormik } from 'formik';
import CustomDropDown from '../CustomDropDown';
import { withStyles } from '@material-ui/styles';
import ProfilePhotoUpload from '../ProfileUpload';
const _ = require('lodash');

const GreenCheckbox = withStyles({
  root: {
    color: green[400],
    '&$checked': {
      color: green[600],
    },
  },
  checked: {},
})((props) => <Checkbox color="default" {...props} />);

const useStyles = makeStyles((theme) => ({
  // input: {
  //   width: '75ch',
  // },
  // button: {
  //   margin: theme.spacing(2),
  // },
}));

const systemRoles = [
  {
    value: '1',
    label: 'Admin',
  },
  {
    value: '3',
    label: 'Operator',
  },
  {
    value: '2',
    label: 'Promoter',
  },
];

const EditSystemOperator = ({
  setOpenPopup,
  setLoading,
  setOpenAlert,
  setError,
  setAlertMessage,
  editFormData,
  refresh,
  setRefresh,
}) => {
  const classes = useStyles();

  const [roles, setRoles] = React.useState(editFormData.role);
  console.log(editFormData.platforms);
  const [mounting, setMounting] = React.useState(false);
  const [companyIDMapping, setCompanyIDMapping] = React.useState();

  let myMap = {};
  let platformsGrantedAccess = editFormData.platforms.split('#');
  platformsGrantedAccess.map((platform) => (myMap[platform] = true));
  const [state, setState] = React.useState({ ...myMap });
  // console.log(state);
  // setState({ ...state, myMap });

  const filteredByValue = Object.fromEntries(
    Object.entries(state).filter(([key, value]) => value === true)
  );
  // console.log(filteredByValue);

  let newPlatforms = Object.keys(filteredByValue).join('#');
  console.log(newPlatforms);

  React.useEffect(() => {
    const fetchData = async () => {
      setMounting(true);
      const res = await fetch(`${API}/api/company-ID-mappings`);
      const json = await res.json();
      setCompanyIDMapping(json);
      setMounting(false);
    };
    fetchData();
  }, []);

  const handleChange = (event) => {
    setState({ ...state, [event.target.name]: event.target.checked });
  };

  const handleDropDownChange = (event) => {
    setRoles(event.target.value);
  };

  const initialValues = {
    firstName: editFormData.firstName,
    lastName: editFormData.lastName,
    role: editFormData.role,
  };

  const onSubmit = (values) => {
    const firstName = values.firstName;
    const lastName = values.lastName;
    const role = values.role;

    //Add record
    const updateUser = async () => {
      setLoading(true);
      const res = await fetch(`${API}/api/update-system-user`, {
        method: 'PUT', // or 'PUT'
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({
          firstName,
          lastName,
          role,
          platforms: newPlatforms,
          ID: editFormData.ID,
        }),
      });
      setLoading(false);
      const json = await res.json();
      if (!json.message) {
        setError(true);
        setAlertMessage('Error Updating User');
        setOpenAlert(true);
      } else {
        setError(false);
        setAlertMessage(json.message);
        setRefresh(!refresh);
        setOpenAlert(true);
      }
    };

    updateUser();
    setRefresh(!refresh);
  };

  const validate = (values) => {
    let errors = {};

    if (!values.firstName) {
      errors.firstName = 'FirstName is Required';
    }

    if (!values.lastName) {
      errors.lastName = 'LastName is Required';
    }

    return errors;
  };

  const formik = useFormik({
    initialValues,
    onSubmit,
    validate,
  });

  return (
    <form noValidate autoComplete="off" onSubmit={formik.handleSubmit}>
      <Grid container spacing={2}>
        <Grid item xs={12}>
          <ProfilePhotoUpload
            userID={editFormData.ID}
            setOpenPopup={setOpenPopup}
          />
        </Grid>
        <Grid item xs={12}>
          <TextField
            fullWidth
            required
            className={classes.input}
            id="firstName"
            label="First Name"
            onChange={formik.handleChange}
            onBlur={formik.handleBlur}
            value={formik.values.firstName}
            helperText={
              formik.touched.firstName && formik.errors.firstName ? (
                <span>{formik.errors.firstName}</span>
              ) : null
            }
            error={
              formik.touched.firstName &&
              Boolean(formik.errors.firstName) &&
              formik.errors.firstName ? (
                <div>{formik.errors.firstName}</div>
              ) : null
            }
          />
        </Grid>
        <Grid item xs={12}>
          <TextField
            fullWidth
            required
            className={classes.input}
            id="lastName"
            label="Last Name"
            onChange={formik.handleChange}
            onBlur={formik.handleBlur}
            value={formik.values.lastName}
            helperText={
              formik.touched.lastName && formik.errors.lastName ? (
                <span>{formik.errors.lastName}</span>
              ) : null
            }
            error={
              formik.touched.lastName &&
              Boolean(formik.errors.lastName) &&
              formik.errors.lastName ? (
                <div>{formik.errors.lastName}</div>
              ) : null
            }
          />
        </Grid>
        <Grid item xs={12}>
          <CustomDropDown
            fullWidth
            variant="outlined"
            size="small"
            label="Select Role"
            style={{ marginTop: 10, marginBottom: 10 }}
            selectedValue={roles}
            handleChange={handleDropDownChange}
            data={systemRoles}
            required
            // className={classes.input}
            id="role"
            onChange={formik.handleChange}
            onBlur={formik.handleBlur}
            value={formik.values.role}
            helperText={
              formik.touched.role && formik.errors.role ? (
                <span>{formik.errors.role}</span>
              ) : null
            }
            error={
              formik.touched.role &&
              Boolean(formik.errors.role) &&
              formik.errors.role ? (
                <div>{formik.errors.role}</div>
              ) : null
            }
          />
        </Grid>
        <Grid item xs={12}>
          <Typography align="center" variant="h6">
            Select Platforms To Access
          </Typography>
          <FormGroup row>
            {/* <FormControlLabel
              control={<GreenCheckbox />}
              label="Grant Access to All"
            /> */}
            {companyIDMapping &&
              companyIDMapping.map((company) => (
                <FormControlLabel
                  control={
                    <GreenCheckbox
                      // checked={name.includes(`${company.value}`)}
                      checked={state[company.value]}
                      name={company.value}
                      onChange={handleChange}
                    />
                  }
                  label={company.label}
                />
              ))}
          </FormGroup>
        </Grid>
        <Grid item xs={12}>
          <Button
            type="submit"
            onClick={() => {
              _.isEmpty(formik.errors) && setOpenPopup(false);
            }}
            fullWidth
            variant="contained"
            color="primary"
            style={{ marginTop: 20 }}
          >
            Save User
          </Button>
        </Grid>
      </Grid>
    </form>
  );
};

export default EditSystemOperator;
