import {
  Button,
  Card,
  CircularProgress,
  Grid,
  makeStyles,
  Typography,
} from '@material-ui/core';
import { GetAppRounded, InfoRounded } from '@material-ui/icons';
import React from 'react';
import CustomDropDown from './CustomDropDown';
import CustomInputField from './CustomInputField';
import ViewContainer from './ViewContainer';
import { API } from '../config';
import CustomSnackBar from './CustomSnackBar';
import { isAuthenticated } from '../API';

const dropDownSelections = [
  {
    value: 'Select Type',
    label: 'Select Type',
  },
  {
    value: '',
    label: 'Loan',
  },
  {
    value: 'other',
    label: 'Other',
  },
];

const useStyles = makeStyles((theme) => ({
  card: {
    minHeight: '40vh',
  },
}));

function Ingenico() {
  const [ingenicoSelections, setIngenicoSelections] =
    React.useState('Select Type');
  const [OTPLoading, setOTPLoading] = React.useState(false);
  const [openAlert, setOpenAlert] = React.useState(false);
  const [alertMessage, setAlertMessage] = React.useState('');
  const [error, setError] = React.useState(false);
  const { mobile } = isAuthenticated();
  const classes = useStyles();

  const handleDropDownChange = (event) => {
    setIngenicoSelections(event.target.value);
  };

  const handleAlertClose = (event, reason) => {
    if (reason === 'clickaway') {
      return;
    }

    setOpenAlert(false);
  };

  //Get OTP Code
  const getOTPCode = async () => {
    setOTPLoading(true);
    const res = await fetch(`${API}/api/request-auth-otp`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ mobile: mobile }),
    });
    const json = await res.json();
    setOTPLoading(false);

    if (!json.message) {
      setError(true);
      setAlertMessage(json.error);
      setOpenAlert(true);
    } else {
      setError(false);
      setAlertMessage(json.message);
      setOpenAlert(true);
    }
  };

  return (
    <>
      <ViewContainer
        icon={<InfoRounded />}
        title="Ingenico-Beyond Payment-3012235"
      >
        <Card raised className={classes.card}>
          <Grid
            container
            item
            spacing={2}
            style={{ display: 'flex', justifyContent: 'center' }}
          >
            <Grid item xs={6} md={3}>
              <CustomInputField
                label="Enter Mobile Number"
                variant="outlined"
                size="small"
                placeholder="Enter mobile number"
                style={{ top: '1rem' }}
              />
            </Grid>
            <Grid item xs={6} md={3}>
              <CustomInputField
                label="Enter Amount"
                variant="outlined"
                size="small"
                placeholder="Enter Amount"
                style={{ top: '1rem' }}
              />
            </Grid>
            <Grid item xs={6} md={3}>
              <CustomDropDown
                variant="outlined"
                size="small"
                // label="Select Type"
                style={{
                  top: '1rem',
                }}
                fullWidth
                selectedValue={ingenicoSelections}
                handleChange={handleDropDownChange}
                data={dropDownSelections}
              />
            </Grid>
            <Grid
              item
              container
              spacing={2}
              style={{ display: 'flex', justifyContent: 'center' }}
            >
              <Grid item xs={6} md={3}>
                <CustomInputField
                  variant="outlined"
                  size="small"
                  value="Mpesa Ksh 19"
                  style={{ top: '1rem', color: 'red' }}
                  disabled
                />
              </Grid>
              <Grid item xs={6} md={3}>
                <CustomInputField
                  label="Enter OTP Code"
                  variant="outlined"
                  size="small"
                  placeholder="Enter OTP Code"
                  style={{ top: '1rem' }}
                  // onChange={handleBulkTransferOTPInputFieldChange}
                />
              </Grid>
              <Grid item xs={6} md={3}>
                <Button
                  variant="contained"
                  style={{ top: '1rem' }}
                  color="primary"
                  fullWidth
                  startIcon={
                    OTPLoading ? (
                      <CircularProgress
                        size={20}
                        style={{ marginRight: 20, color: '#fff' }}
                      />
                    ) : (
                      <GetAppRounded />
                    )
                  }
                  onClick={getOTPCode}
                >
                  Get OTP
                </Button>
              </Grid>
            </Grid>
            <Grid
              container
              item
              spacing={2}
              style={{ display: 'flex', justifyContent: 'center' }}
            >
              <Grid item xs={6} md={9}>
                <Button
                  variant="contained"
                  style={{ top: '1rem' }}
                  color="primary"
                  fullWidth
                  // onClick={bulkFilter}
                  // startIcon={
                  //   loading ? (
                  //     <CircularProgress
                  //       size={20}
                  //       style={{ marginRight: 20, color: '#fff' }}
                  //     />
                  //   ) : (
                  //     <RotateRightRounded />
                  //   )
                  // }
                >
                  Send
                </Button>
              </Grid>
            </Grid>
          </Grid>
        </Card>
      </ViewContainer>
      <CustomSnackBar
        vertical="top"
        horizontal="center"
        severity={error ? 'error' : 'success'}
        open={openAlert}
        handleClose={handleAlertClose}
        hideDuration={6000}
        message={alertMessage}
      />
    </>
  );
}

export default Ingenico;
