import {
  Container,
  makeStyles,
  MenuItem,
  MenuList,
  Typography,
} from '@material-ui/core';
import {
  BuildRounded,
  ConfirmationNumberRounded,
  EmailRounded,
  LanguageRounded,
  MessageRounded,
  PaymentRounded,
  PeopleAltRounded,
  ReceiptRounded,
  SendRounded,
  StorageOutlined,
  SupervisedUserCircleRounded,
  ThumbUpRounded,
} from '@material-ui/icons';
import { Link, useLocation } from 'react-router-dom';
import { isAuthenticated } from '../API';

const useStyles = makeStyles((theme) => ({
  container: {
    height: '100vh',
    color: 'white',
    paddingTop: theme.spacing(10),
    backgroundColor: '#3C8016',
    margin: 0,
    position: 'sticky',
    top: 0,
    [theme.breakpoints.up('sm')]: {
      backgroundColor: '#3C8016',
      color: '#555',
      border: '1px solid #ece7e7',
    },
  },
  item: {
    display: 'flex',
    alignItems: 'center',
    // marginBottom: theme.spacing(4),
    [theme.breakpoints.up('sm')]: {
      marginBottom: theme.spacing(3),
      cursor: 'pointer',
    },
    '&:focus': {
      backgroundColor: theme.palette.primary.main,
      '& .MuiListItemIcon-root, & .MuiListItemText-primary': {
        color: theme.palette.common.white,
      },
    },
  },
  icon: {
    marginRight: theme.spacing(1),
    [theme.breakpoints.up('sm')]: {
      fontSize: '18px',
    },
  },
  text: {
    fontWeight: 500,
    [theme.breakpoints.down('sm')]: {
      display: 'none',
    },
  },
  menuItem: {
    backgroundColor: '#3C8016',
    color: '#fff',
    fontFamily: 'open-sans',
    marginBottom: 10,
    '&:hover': {
      backgroundColor: theme.palette.primary.main,
      color: theme.palette.common.white,
    },
    '&:focus': {
      backgroundColor: theme.palette.primary.main,
      color: '#FFF',
      '& .MuiListItemIcon-root, & .MuiListItemText-primary': {
        color: theme.palette.common.white,
      },
    },
  },
}));

const LeftBar = () => {
  const location = useLocation();
  const classes = useStyles();
  const { mobile } = isAuthenticated();

  return (
    <Container className={classes.container}>
      <MenuList>
        {mobile !== null && mobile === '254720740895' ? (
          <>
            <MenuItem
              component={Link}
              to="/transactions"
              selected={'/transactions' === location.pathname}
              className={classes.menuItem}
            >
              <ReceiptRounded className={classes.icon} />
              <Typography className={classes.text}>Transactions</Typography>
            </MenuItem>
          </>
        ) : mobile !== null && mobile === '254708672888' ? (
          <>
            <MenuItem
              component={Link}
              to="/transactions"
              selected={'/transactions' === location.pathname}
              className={classes.menuItem}
            >
              <ReceiptRounded className={classes.icon} />
              <Typography className={classes.text}>Transactions</Typography>
            </MenuItem>
          </>
        ) : mobile !== null && mobile === '254711664398' ? (
          <>
            <MenuItem
              component={Link}
              to="/transactions"
              selected={'/transactions' === location.pathname}
              className={classes.menuItem}
            >
              <ReceiptRounded className={classes.icon} />
              <Typography className={classes.text}>Transactions</Typography>
            </MenuItem>
            <MenuItem
              component={Link}
              to="/send-message"
              selected={'/send-message' === location.pathname}
              className={classes.menuItem}
            >
              <SendRounded className={classes.icon} />
              <Typography className={classes.text}>Send Message</Typography>
            </MenuItem>
            <MenuItem
              component={Link}
              to="/bulk-sms"
              selected={'/bulk-sms' === location.pathname}
              className={classes.menuItem}
            >
              <EmailRounded className={classes.icon} />
              <Typography className={classes.text}>Bulk SMS Account</Typography>
            </MenuItem>
          </>
        ) : (
          <>
            <MenuItem
              component={Link}
              to="/administrator"
              selected={'/administrator' === location.pathname}
              className={classes.menuItem}
              classes={{ selected: classes.selected }}
            >
              <SupervisedUserCircleRounded className={classes.icon} />
              <Typography className={classes.text}>Administrator</Typography>
            </MenuItem>
            <MenuItem
              component={Link}
              to="/maintainance"
              selected={'/maintainance' === location.pathname}
              className={classes.menuItem}
            >
              <BuildRounded className={classes.icon} />
              <Typography className={classes.text}>Maintainance</Typography>
            </MenuItem>
            <MenuItem
              component={Link}
              to="/payments"
              selected={'/payments' === location.pathname}
              className={classes.menuItem}
            >
              <PaymentRounded className={classes.icon} />
              <Typography className={classes.text}>Payments</Typography>
            </MenuItem>
            <MenuItem
              component={Link}
              to="/transactions"
              selected={'/transactions' === location.pathname}
              className={classes.menuItem}
            >
              <ReceiptRounded className={classes.icon} />
              <Typography className={classes.text}>Transactions</Typography>
            </MenuItem>
            <MenuItem
              component={Link}
              to="/send-message"
              selected={'/send-message' === location.pathname}
              className={classes.menuItem}
            >
              <SendRounded className={classes.icon} />
              <Typography className={classes.text}>Send Message</Typography>
            </MenuItem>
            <MenuItem
              component={Link}
              to="/sent-messages"
              selected={'/sent-messages' === location.pathname}
              className={classes.menuItem}
            >
              <MessageRounded className={classes.icon} />
              <Typography className={classes.text}>Sent Messages</Typography>
            </MenuItem>
            <MenuItem
              component={Link}
              to="/bulk-sms"
              selected={'/bulk-sms' === location.pathname}
              className={classes.menuItem}
            >
              <EmailRounded className={classes.icon} />
              <Typography className={classes.text}>Bulk SMS Account</Typography>
            </MenuItem>
            <MenuItem
              component={Link}
              to="/supernova"
              selected={'/supernova' === location.pathname}
              className={classes.menuItem}
            >
              <ThumbUpRounded className={classes.icon} />
              <Typography className={classes.text}>Supernova W</Typography>
            </MenuItem>
            <MenuItem
              component={Link}
              to="/tickets"
              selected={'/tickets' === location.pathname}
              className={classes.menuItem}
            >
              <ConfirmationNumberRounded className={classes.icon} />
              <Typography className={classes.text}>Tickets</Typography>
            </MenuItem>
            <MenuItem
              component={Link}
              to="/database"
              selected={'/database' === location.pathname}
              className={classes.menuItem}
            >
              <StorageOutlined className={classes.icon} />
              <Typography className={classes.text}>Database</Typography>
            </MenuItem>
            <MenuItem
              component={Link}
              to="/world-center"
              selected={'/world-center' === location.pathname}
              className={classes.menuItem}
            >
              <LanguageRounded className={classes.icon} />
              <Typography className={classes.text}>World Center</Typography>
            </MenuItem>
            <MenuItem
              component={Link}
              to="/users"
              selected={'/users' === location.pathname}
              className={classes.menuItem}
            >
              <PeopleAltRounded className={classes.icon} />
              <Typography className={classes.text}>Users</Typography>
            </MenuItem>
          </>
        )}
      </MenuList>
    </Container>
  );
};

export default LeftBar;
