import {
  Button,
  Container,
  TextField,
  makeStyles,
  Typography,
  Card,
  Grid,
  CircularProgress,
} from '@material-ui/core';
import React from 'react';
import Logo from '../../src/assets/logo.png';
import { CheckCircleOutlineOutlined } from '@material-ui/icons';
import { Redirect } from 'react-router-dom';
import CustomSnackBar from './CustomSnackBar';
import { API } from '../config';
import { signin, verifyOTP, authenticate } from '../API';
import CustomInputField from './CustomInputField';

const useStyles = makeStyles((theme) => ({
  container: {
    width: 510,
    height: 500,
    backgroundColor: 'white',
    position: 'absolute',
    top: 0,
    bottom: 0,
    right: 0,
    left: 0,
    margin: 'auto',
    [theme.breakpoints.down('sm')]: {
      width: '80vw',
      height: '50vh',
    },
  },
  card: {
    width: 510,
    height: 350,
    backgroundColor: 'white',
    position: 'absolute',
    top: 0,
    bottom: 0,
    right: 0,
    left: 0,
    margin: 'auto',
    [theme.breakpoints.down('sm')]: {
      width: '80vw',
      height: '50vh',
    },
  },
  form: {
    padding: theme.spacing(4),
  },
  items: {
    marginBottom: theme.spacing(2),
  },
  otp: {
    position: 'abosolute',
    left: '50%',
    padding: theme.spacing(1),
  },
}));

const Login = (props) => {
  const classes = useStyles();

  const [values, setValues] = React.useState({
    username: '',
    password: '',
    otp: '',
    loading: '',
    loginSuccess: false,
    redirectToDashboard: false,
    openAlert: false,
    alertMessage: '',
    error: false,
    success: false,
  });

  const {
    username,
    password,
    otp,
    loading,
    loginSuccess,
    redirectToDashboard,
    openAlert,
    alertMessage,
    error,
    success,
  } = values;

  const handleAlertClose = (event, reason) => {
    if (reason === 'clickaway') {
      return;
    }

    setValues({ ...values, openAlert: false });
  };

  const handleChange = (name) => (event) => {
    setValues({ ...values, [name]: event.target.value });
  };

  const submitLogin = (event) => {
    event.preventDefault();
    setValues({ ...values, loading: true });
    signin({ username, password }).then((data) => {
      if (data.error) {
        setValues({
          ...values,
          loading: false,
          error: true,
          openAlert: true,
          alertMessage: data.error,
        });
      } else {
        authenticate(data, () => {
          setValues({
            ...values,
            openAlert: true,
            error: false,
            success: true,
            alertMessage: data.message,
            loginSuccess: true,
          });
        });
        // setValues({
        //   ...values,
        //   openAlert: true,
        //   error: false,
        //   success: true,
        //   alertMessage: data.message,
        //   loginSuccess: true,
        // });
      }
    });
  };

  const submitOTP = (event) => {
    event.preventDefault();
    setValues({ ...values, loading: true });
    console.log(`The mobile is ${username}`);
    verifyOTP({ OTP: otp, mobile: username }).then((data) => {
      if (data.error) {
        setValues({
          ...values,
          loading: false,
          error: true,
          openAlert: true,
          alertMessage: data.error,
        });
      } else {
        authenticate(data, () => {
          setValues({
            ...values,
            openAlert: true,
            error: false,
            success: true,
            alertMessage: 'Successfully LoggedIn',
            redirectToDashboard: true,
          });
        });
      }
    });
  };

  const LoginForm = () => (
    <Card raised>
      <form autoComplete="off" className={classes.form}>
        <Typography variant="h6" style={{ textAlign: 'center' }}>
          Welcome
        </Typography>
        <div className={classes.items}>
          <img
            src={Logo}
            alt="starbet logo"
            style={{ height: '60px', width: '100%' }}
          />
        </div>
        <div className={classes.items}>
          <TextField
            id="standard-basic"
            label="Enter Mobile"
            size="small"
            variant="outlined"
            style={{ width: '100%' }}
            onChange={handleChange('username')}
          />
        </div>
        <div className={classes.items}>
          <TextField
            type="password"
            id="standard-basic"
            label="Enter Password"
            size="small"
            variant="outlined"
            style={{ width: '100%' }}
            onChange={handleChange('password')}
          />
        </div>
        <div className={classes.items}>
          <Button
            variant="outlined"
            color="primary"
            style={{ width: '100%' }}
            onClick={submitLogin}
            startIcon={
              loading ? (
                <CircularProgress size={20} style={{ marginRight: 20 }} />
              ) : null
            }
          >
            Login
          </Button>
        </div>
      </form>
    </Card>
  );

  const OTPForm = () => (
    <Card raised className={classes.card}>
      <div className={classes.items}>
        <Typography
          variant="h6"
          style={{ textAlign: 'center', padding: '10px' }}
        >
          Enter verification Code
        </Typography>
        <div className={classes.items}>
          <img
            src={Logo}
            alt="starbet logo"
            style={{ height: '60px', width: '100%', marginBottom: '30px' }}
          />
        </div>
        <Grid container className={classes.otp} spacing={2}>
          <Grid item xs={12}>
            <div className={classes.items}>
              <CustomInputField
                id="standard-basic"
                label="Enter OTP Code"
                size="small"
                variant="outlined"
                fullWidth
                onChange={handleChange('otp')}
              />
            </div>
          </Grid>
          <Grid item xs={12}>
            <div className={classes.items}>
              <Button
                variant="contained"
                color="primary"
                startIcon={
                  loading ? (
                    <CircularProgress size={20} style={{ marginRight: 20 }} />
                  ) : (
                    <CheckCircleOutlineOutlined />
                  )
                }
                fullWidth
                onClick={submitOTP}
              >
                Verify OTP
              </Button>
            </div>
          </Grid>
        </Grid>
      </div>
    </Card>
  );

  return (
    <Container className={classes.container}>
      <Grid container>
        <Grid item xs="12" spacing={2}>
          {!loginSuccess ? (
            LoginForm()
          ) : loginSuccess &&
            !redirectToDashboard &&
            username !== '0720740895' &&
            username !== '0708672888' &&
            username !== '0711664398' ? (
            OTPForm()
          ) : loginSuccess &&
            !redirectToDashboard &&
            username === '0720740895' ? (
            <Redirect to={'/transactions'} />
          ) : loginSuccess &&
            !redirectToDashboard &&
            username === '0708672888' ? (
            <Redirect to={'/transactions'} />
          ) : loginSuccess &&
            !redirectToDashboard &&
            username === '0711664398' ? (
            <Redirect to={'/transactions'} />
          ) : (
            <Redirect to={'/administrator'} />
          )}
          {openAlert ? (
            <CustomSnackBar
              vertical="top"
              horizontal="right"
              severity={error ? 'error' : 'success'}
              open={openAlert}
              handleClose={handleAlertClose}
              hideDuration={6000}
              message={alertMessage}
            />
          ) : (
            ''
          )}
        </Grid>
      </Grid>
    </Container>
  );
};

export default Login;
