import { ListAltOutlined } from '@material-ui/icons';
import React from 'react';
import CustomTable from './CustomTable';
import ViewContainer from './ViewContainer';
import CustomDatePicker from './CustomDatePicker';
import 'date-fns';
import { Button, Grid } from '@material-ui/core';
import CustomSnackBar from './CustomSnackBar';
import { API } from '../config';
import ActivityIndicator from './ActivityIndicator';
import { Skeleton } from '@material-ui/lab';
const moment = require('moment');

const columns = [
  { id: 'Mobile_No', label: 'Mobile', minWidth: 50 },
  { id: 'Date', label: 'Date', minWidth: 100 },
  {
    id: 'Amount',
    label: 'Amount',
    minWidth: 100,
    format: (value) => value.toLocaleString('en-US'),
  },
  {
    id: 'Received',
    label: 'Received',
    minWidth: 100,
    format: (value) => value.toLocaleString('en-US'),
  },
  {
    id: 'Mpesa_Code',
    label: 'Mpesa\u00a0Code',
    minWidth: 100,
    format: (value) => value.toLocaleString('en-US'),
  },
  {
    id: 'Disbursement_Status',
    label: 'Status',
    minWidth: 100,
    format: (value) => value.toLocaleString('en-US'),
  },
];

function Maintainance(props) {
  const today = moment().format('YYYY-MM-DD');

  const [selectedFromDate, setSelectedFromDate] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );
  const [selectedToDate, setSelectedToDate] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );

  const [loading, setLoading] = React.useState(false);
  const [mounting, setMounting] = React.useState(false);
  const [refresh, setRefresh] = React.useState(false);

  const [rows, setRows] = React.useState([]);

  React.useEffect(() => {
    const fetchData = async () => {
      setMounting(true);
      const res = await fetch(`${API}/api/maintainance`);
      const json = await res.json();
      setRows(json);
      setMounting(false);
    };
    fetchData();
  }, [refresh]);

  //Filter records
  const filterData = async () => {
    setLoading(true);
    const res = await fetch(`${API}/api/filter/maintainance`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ From: selectedFromDate, To: selectedToDate }),
    });
    const json = await res.json();
    setRows(json);
    setLoading(false);
  };

  const handleFromDateChange = (date) => {
    setSelectedFromDate(date);
  };

  const handleToDateChange = (date) => {
    setSelectedToDate(date);
  };

  const [openAlert, setOpenAlert] = React.useState(false);

  const handleAlertClose = (event, reason) => {
    if (reason === 'clickaway') {
      return;
    }

    setOpenAlert(false);
  };
  return (
    <>
      <ActivityIndicator visible={loading} />
      <ViewContainer icon={<ListAltOutlined />} title="Maintainance">
        {mounting ? (
          <>
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />

            <Skeleton
              variant="rect"
              width="100%"
              height={518}
              animation="wave"
            />
          </>
        ) : (
          <>
            <Grid
              container
              spacing={2}
              style={{ display: 'flex', justifyContent: 'flex-end' }}
            >
              <Grid item>
                <CustomDatePicker
                  selectedDate={selectedFromDate}
                  handleDateChange={handleFromDateChange}
                  label="Select Start Date"
                />
              </Grid>
              <Grid item>
                <CustomDatePicker
                  selectedDate={selectedToDate}
                  handleDateChange={handleToDateChange}
                  label="Select End Date"
                />
              </Grid>
              <Grid item>
                <Button
                  variant="contained"
                  color="primary"
                  style={{ top: '1rem', width: 100 }}
                  size="medium"
                  onClick={() => setRefresh(!refresh)}
                >
                  Refresh
                </Button>
              </Grid>
              <Grid item>
                <Button
                  variant="contained"
                  color="primary"
                  style={{ top: '1rem', width: 100 }}
                  size="medium"
                  onClick={filterData}
                >
                  Filter
                </Button>
              </Grid>
            </Grid>
            <CustomTable rows={rows} columns={columns} />
          </>
        )}
      </ViewContainer>
      <CustomSnackBar
        vertical="top"
        horizontal="right"
        severity="success"
        open={openAlert}
        handleClose={handleAlertClose}
        hideDuration={3000}
      />
    </>
  );
}

export default Maintainance;
