import React, { useState, useEffect } from 'react';
import ReactCountryFlag from 'react-country-flag';
import Clock from 'react-clock';
import 'react-clock/dist/Clock.css';
import { API } from '../config';

const MyClock = (props) => {
  const [time, setTime] = useState(getCurrentTime());

  useEffect(() => {
    const intervalID = setInterval(() => tick(), 1000);
    return () => clearInterval(intervalID);
  }, []);

  function getCurrentTime() {
    const today = new Date();
    const options = {
      timeZone: props.Timezone,
    };
    return today.toLocaleString('en-US', options);
  }

  function tick() {
    setTime(getCurrentTime());
  }

  const removeClock = () => {
    fetch(`${API}/api/delete-clock`, {
      method: 'DELETE',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ id: props.id }),
    })
      .then((response) => {
        if (response.ok) {
          // Clock successfully deleted, perform necessary actions (e.g., remove from UI)
          props.onRemove(props.id);
        } else {
          // Handle error case
        }
      })
      .catch((error) => {
        // Handle error case
      });
  };

  return (
    <div>
      <div
        style={{
          padding: 10,
          border: '1px solid black',
          marginRight: 10,
        }}
      >
        <div style={{ display: 'flex', alignItems: 'center' }}>
          <div style={{ marginRight: '8px' }}>
            <ReactCountryFlag countryCode={props.ISO} svg />
          </div>
          <h5>{props.Country}</h5>
        </div>
        <div
          style={{
            display: 'flex',
            alignItems: 'center',
          }}
        >
          <Clock
            value={time}
            renderNumbers={true}
            size={160}
            renderMinuteMarks={true}
          />
        </div>
        <div>
          <p>{time.toLocaleString()}</p>
        </div>
        <button
          onClick={removeClock}
          style={{ background: '#3C8015', color: 'white' }}
        >
          Remove Clock
        </button>
      </div>
    </div>
  );
};

export default MyClock;
