import {
  AppBar,
  Toolbar,
  Typography,
  makeStyles,
  Avatar,
  MenuItem,
  Menu,
} from '@material-ui/core';
import React from 'react';
import Logo from '../../src/assets/logo.png';
import { Link } from 'react-router-dom';
import ExitToAppIcon from '@material-ui/icons/ExitToApp';
import { signout, isAuthenticated } from '../API';
import { API } from '../config';

const useStyles = makeStyles((theme) => ({
  toolbar: {
    display: 'flex',
    // #3C8016
    backgroundColor: '#fff',
    justifyContent: 'space-between',
    height: '70px',
    color: '#000',
  },
  logoLg: {
    display: 'none',
    [theme.breakpoints.up('sm')]: {
      display: 'flex',
      alignItems: 'center',
    },
  },
  logoSM: {
    display: 'block',
    [theme.breakpoints.up('sm')]: {
      display: 'none',
    },
  },
  icons: {
    display: 'flex',
    alignItems: 'center',
  },
}));

const NavBar = () => {
  const classes = useStyles();

  const [anchorEl, setAnchorEl] = React.useState(null);
  const { Firstname, Lastname, ID } = isAuthenticated();
  const [profileUrl, setProfileUrl] = React.useState(null);

  const handleClose = () => {
    setAnchorEl(null);
  };

  const handleClick = (event) => {
    setAnchorEl(event.currentTarget);
  };

  React.useEffect(() => {
    async function getData() {
      const response = await fetch(`${API}/api/get-user-profile-picture`, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ id: ID }),
      });

      if (response.ok) {
        const data = await response.json();
        // Clock added successfully, fetch the updated list of clocks
        console.log('ok', data);
        const cleanedData = data[0];
        setProfileUrl(cleanedData.Profile_url);
      } else {
        // Handle error case
        console.log(response);
        throw new Error('Error adding clock');
      }
    }

    getData();
  }, []);

  return (
    <AppBar position="fixed">
      <Toolbar className={classes.toolbar}>
        <div className={classes.icons}>
          {profileUrl !== null ? (
            <img
              src={profileUrl}
              alt="Profile"
              style={{
                height: '50px',
                width: '50px',
                borderRadius: '35px',
              }}
            />
          ) : (
            // <AccountCircleIcon
            //   style={{ color: 'blue', height: 40, width: 40 }}
            // />
            <Avatar
              style={{ color: 'blue', height: 40, width: 40 }}
              onClick={handleClick}
              alt="profile"
              src={`https://ui-avatars.com/api/?name=${Firstname}+${Lastname}&background=093C99&color=fff`}
            />
          )}
          <Typography variant="body2" style={{ marginRight: 4 }}>
            Welcome {Firstname} {Lastname}
          </Typography>
          <Menu
            id="menu-appbar"
            anchorEl={anchorEl}
            keepMounted
            open={Boolean(anchorEl)}
            onClose={handleClose}
            anchorOrigin={{
              vertical: 'bottom',
              horizontal: 'left',
            }}
          >
            <MenuItem
              onClick={() => {
                signout();
                handleClose();
              }}
            >
              <Link to="/" style={{ textDecoration: 'none' }}>
                Logout
              </Link>
            </MenuItem>
          </Menu>
          {/* <Avatar
            onClick={handleClick}
            alt="profile"
            src={`https://ui-avatars.com/api/?name=${Firstname}+${Lastname}&background=093C99&color=fff`}
          /> */}
        </div>
        <div className={classes.logoLg}>
          <img
            src={Logo}
            alt="dairy logo"
            style={{
              height: '70px',
              width: '250px',
            }}
          />
        </div>
        <Typography variant="h6" className={classes.logoSM}>
          Dairy Pesa
        </Typography>
        <div className={classes.icons}>
          {/* <Typography variant="body2" style={{ marginRight: 4 }}>
            Welcome {Firstname}
          </Typography> */}
          <div>
            <Menu
              id="menu-appbar"
              anchorEl={anchorEl}
              keepMounted
              open={Boolean(anchorEl)}
              onClose={handleClose}
              anchorOrigin={{
                vertical: 'bottom',
                horizontal: 'left',
              }}
            >
              <MenuItem
                onClick={() => {
                  handleClose();
                }}
              >
                <Link to="/my-profile" style={{ textDecoration: 'none' }}>
                  My Profile
                </Link>
              </MenuItem>
              <MenuItem
                onClick={() => {
                  signout();
                  handleClose();
                }}
              >
                <Link to="/" style={{ textDecoration: 'none' }}>
                  Logout
                </Link>
              </MenuItem>
            </Menu>
            <ExitToAppIcon onClick={handleClick} style={{ color: 'blue' }} />
            {/* <Avatar
              onClick={handleClick}
              alt="profile"
              src={`https://ui-avatars.com/api/?name=${Firstname}+${Lastname}&background=093C99&color=fff`}
            /> */}
          </div>
        </div>
      </Toolbar>
    </AppBar>
  );
};

export default NavBar;
