import { Button, Grid, IconButton, Tooltip } from '@material-ui/core';
import {
  AccountBalanceRounded,
  AddCircleRounded,
  DeleteForeverOutlined,
  EditRounded,
} from '@material-ui/icons';
import React from 'react';
import ActivityIndicator from './ActivityIndicator';
import CustomTable from './CustomTable';
import { API } from '../config';
import ViewContainer from './ViewContainer';
import { Skeleton } from '@material-ui/lab';
import CustomConfirmDialog from './CustomConfirmDialog';
import CustomModal from './CustomModal';
import EditPlatformAccount from './Forms/EditPlatformAccount';
import AddPlatformAccount from './Forms/AddPlatformAccount';
import CustomSnackBar from './CustomSnackBar';

const columns = [
  { id: 'Company', label: 'Company', minWidth: 50 },
  { id: 'PayBill', label: 'PayBill', minWidth: 100 },
  {
    id: 'Bank',
    label: 'Bank',
    minWidth: 100,
  },
  {
    id: 'Acc_Number',
    label: 'Account\u00a0Number',
    minWidth: 100,
  },
];

function PlatformAccounts() {
  const [alertMessage, setAlertMessage] = React.useState('');
  const [error, setError] = React.useState(false);
  const [formData, setFormData] = React.useState({
    Company: '',
    Paybill: '',
    Bank: '',
    Account: '',
  });
  const [refresh, setRefresh] = React.useState(false);
  const [openAlert, setOpenAlert] = React.useState(false);
  const [openPopup, setOpenPopup] = React.useState(false);
  const [edit, setEdit] = React.useState(false);
  const [add, setAdd] = React.useState(false);
  const [rows, setRows] = React.useState([]);
  const [loading, setLoading] = React.useState(false);
  const [confirmDialog, setConfirmDialog] = React.useState({
    isOpen: false,
    title: '',
    subtitle: '',
  });

  const handleAlertClose = (event, reason) => {
    if (reason === 'clickaway') {
      return;
    }

    setOpenAlert(false);
  };

  //Delete Platform Account
  const deleteData = async (ID) => {
    setLoading(true);
    const res = await fetch(`${API}/api/delete-platform-account`, {
      method: 'DELETE', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ ID }),
    });
    setLoading(false);
    const json = await res.json();
    // console.log(json);
    if (!json.message) {
      setError(true);
      setAlertMessage('Error Deleting Platform Account');
      setOpenAlert(true);
    } else {
      setError(true);
      setAlertMessage(json.message);
      setOpenAlert(true);
    }
    setConfirmDialog({ ...confirmDialog, isOpen: false });
    setRefresh(!refresh);
  };

  const deleteActionIcon = (row) => (
    <Tooltip title="Delete PlatForm Account">
      <IconButton
        style={{ color: 'red' }}
        size="small"
        onClick={() => {
          setConfirmDialog({
            isOpen: true,
            title: 'Are you sure you want to delete this Platform Account?',
            subtitle: "You can't undo this operation",
            onConfirm: () => {
              deleteData(row.ID);
            },
          });
        }}
      >
        <DeleteForeverOutlined />
      </IconButton>
    </Tooltip>
  );

  const editActionIcon = (row) => (
    <Tooltip title="Edit PlatForm Account">
      <IconButton
        onClick={() => {
          setOpenPopup(!openPopup);
          setFormData({
            ...formData,
            Company: row.Company,
            Paybill: row.PayBill,
            Bank: row.Bank,
            Account: row.Acc_Number,
            ID: row.ID,
          });
          setEdit(true);
        }}
        style={{ color: 'blue' }}
        size="small"
      >
        <EditRounded />
      </IconButton>
    </Tooltip>
  );

  const actionIconsArray = [editActionIcon, deleteActionIcon];

  React.useEffect(() => {
    const fetchData = async () => {
      setLoading(true);
      const res = await fetch(`${API}/api/platform-accounts`);
      const json = await res.json();
      setRows(json);
      setLoading(false);
    };
    fetchData();
  }, [refresh]);

  return (
    <>
      <ActivityIndicator visible={loading} />
      <ViewContainer icon={<AccountBalanceRounded />} title="Platform Accounts">
        {loading ? (
          <>
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />

            <Skeleton
              variant="rect"
              width="100%"
              height={518}
              animation="wave"
            />
          </>
        ) : (
          <>
            <Grid
              container
              spacing={2}
              style={{ display: 'flex', justifyContent: 'flex-end' }}
            >
              <Grid item>
                <Button
                  variant="contained"
                  color="primary"
                  startIcon={<AddCircleRounded />}
                  style={{ marginBottom: '10px' }}
                  onClick={() => {
                    setOpenPopup(!openPopup);
                    setEdit(false);
                    setAdd(true);
                  }}
                >
                  Add Platform Account
                </Button>
              </Grid>
            </Grid>
            <CustomTable
              columns={columns}
              rows={rows}
              actions={true}
              actionIcons={actionIconsArray}
              rowCount={true}
            />
          </>
        )}
      </ViewContainer>
      <CustomModal
        openPopup={openPopup}
        setOpenPopup={setOpenPopup}
        title={
          edit
            ? 'Edit Platform Account'
            : add
            ? 'Add Platform Account'
            : 'Title'
        }
      >
        {edit ? (
          <EditPlatformAccount
            setOpenPopup={setOpenPopup}
            setLoading={setLoading}
            openAlert={openAlert}
            setOpenAlert={setOpenAlert}
            setError={setError}
            setAlertMessage={setAlertMessage}
            setRefresh={setRefresh}
            refresh={refresh}
            editFormData={formData}
          />
        ) : add ? (
          <AddPlatformAccount
            setOpenPopup={setOpenPopup}
            setLoading={setLoading}
            openAlert={openAlert}
            setOpenAlert={setOpenAlert}
            setError={setError}
            setAlertMessage={setAlertMessage}
            setRefresh={setRefresh}
            refresh={refresh}
          />
        ) : (
          'Testing'
        )}
      </CustomModal>
      <CustomConfirmDialog confirmDialog={confirmDialog}>
        <Button
          variant="outlined"
          color="primary"
          onClick={() => setConfirmDialog({ isOpen: false })}
        >
          No
        </Button>
        <Button
          variant="contained"
          color="secondary"
          onClick={() => {
            confirmDialog.onConfirm();
          }}
        >
          Yes
        </Button>
      </CustomConfirmDialog>
      <CustomSnackBar
        vertical="top"
        horizontal="right"
        severity={error ? 'error' : 'success'}
        open={openAlert}
        handleClose={handleAlertClose}
        hideDuration={6000}
        message={alertMessage}
      />
    </>
  );
}

export default PlatformAccounts;
