import { InfoRounded } from '@material-ui/icons';
import React from 'react';
import CustomTable from './CustomTable';
import ViewContainer from './ViewContainer';
import { API } from '../config';
import ActivityIndicator from './ActivityIndicator';
import { Skeleton } from '@material-ui/lab';

const columns = [
  { id: 'Date', label: 'Date', minWidth: 50 },
  { id: 'Username', label: 'Username', minWidth: 100 },
  {
    id: 'Firstname',
    label: 'Firstname',
    minWidth: 100,
  },
  {
    id: 'Lastname',
    label: 'Lastname',
    minWidth: 100,
  },
  {
    id: 'Email',
    label: 'Email',
    minWidth: 100,
  },
];

function PlatformLogs() {
  const [rows, setRows] = React.useState([]);
  const [loading, setLoading] = React.useState(false);

  React.useEffect(() => {
    const fetchData = async () => {
      setLoading(true);
      const res = await fetch(`${API}/api/login-trails`);
      const json = await res.json();
      setRows(json);
      setLoading(false);
    };
    fetchData();
  }, []);

  return (
    <>
      {/* <ActivityIndicator visible={loading} /> */}
      <ViewContainer icon={<InfoRounded />} title="Login Trails">
        {loading ? (
          <>
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />

            <Skeleton
              variant="rect"
              width="100%"
              height={518}
              animation="wave"
            />
          </>
        ) : (
          <CustomTable rows={rows} columns={columns} />
        )}
      </ViewContainer>
    </>
  );
}

export default PlatformLogs;
