import React, { useState } from 'react';
import './ProfilePhotoUploadCss.css';
import { API } from '../config';

const ProfilePhotoUpload = (props) => {
  const [selectedFile, setSelectedFile] = useState(null);
  const [previewImage, setPreviewImage] = useState(null);
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(false);
  const [openAlert, setOpenAlert] = useState(false);
  const [refresh, setRefresh] = useState(false);
  const [alertMessage, setAlertMessage] = useState('');

  const handleFileInputChange = (event) => {
    setSelectedFile(event.target.files[0]);
    setPreviewImage(URL.createObjectURL(event.target.files[0]));
  };

  const handleSubmit = (event) => {
    event.preventDefault();
    console.log(selectedFile);
    let formData = new FormData();
    formData.append('file', selectedFile);
    formData.append('userID', props.userID);
    // TODO: handle form submission
    //Add record
    const insertData = async () => {
      setLoading(true);
      console.log('file', selectedFile);
      const res = await fetch(`${API}/api/Upload-Profile`, {
        method: 'POST', // or 'PUT'
        body: formData,
      });
      setLoading(false);
      const json = await res.json();
      if (!json.message) {
        setError(true);
        setAlertMessage('Error Adding User');
        setOpenAlert(true);
        props.setOpenPopup(false);
      } else {
        setError(false);
        setAlertMessage(json.message);
        setOpenAlert(true);
        props.setOpenPopup(false);
        setRefresh(!refresh);
      }
    };
    insertData();
  };

  return (
    <form>
      <div className="profile-photo-upload">
        <label htmlFor="file-input">
          {previewImage ? (
            <img src={previewImage} alt="Preview" />
          ) : (
            <div className="upload-placeholder">
              <span>+</span>
              <p>Upload a photo</p>
            </div>
          )}
        </label>
        <input
          id="file-input"
          name="file"
          type="file"
          accept="image/*"
          onChange={handleFileInputChange}
        />
      </div>
      <button
        type="button"
        onClick={handleSubmit}
        id="upload-btn"
        disabled={selectedFile === null ? true : false}
      >
        {loading ? 'uploading...' : 'Upload'}
      </button>
    </form>
  );
};

export default ProfilePhotoUpload;
