import React from 'react';
import {
  ScheduleRounded,
  PhonelinkLockRounded,
  VisibilityRounded,
  BlockRounded,
  FileCopyRounded,
} from '@material-ui/icons';
import ViewContainer from './ViewContainer';
import CustomTable from './CustomTable';
import {
  Button,
  Divider,
  Grid,
  IconButton,
  MenuItem,
  TextField,
  Tooltip,
  Typography,
} from '@material-ui/core';
import CustomDropDown from './CustomDropDown';
import { API } from '../config';
import CustomInputField from './CustomInputField';
import CustomDateTimePicker from './CustomDateTimePicker';
import CustomDatePicker from './CustomDatePicker';
import { Skeleton } from '@material-ui/lab';
import ActivityIndicator from './ActivityIndicator';
import CustomConfirmDialog from './CustomConfirmDialog';
import CustomSnackBar from './CustomSnackBar';
import { isAuthenticated } from '../API';
const copy = require('clipboard-copy');
const moment = require('moment');

const columns = [
  { id: 'id', label: 'ID', maxWidth: 20 },
  { id: 'SMS_Date', label: 'SMS\u00a0Date', minWidth: 50 },
  {
    id: 'SMS_Time',
    label: 'SMS\u00a0Time',
    minWidth: 50,
  },
  {
    id: 'SMS_Type',
    label: 'SMS\u00a0Type',
    minWidth: 50,
  },
  {
    id: 'SMS_Status',
    label: 'SMS_Status',
    minWidth: 50,
  },
];

const someOtherInfo = [
  {
    value: 'none',
    label: 'None',
  },
  {
    value: '1',
    label: 'Specific',
  },
  {
    value: '2',
    label: 'All',
  },
  {
    value: '3',
    label: 'Reserved',
  },
  {
    value: '31',
    label: 'Master',
  },
];

const smsTypes = [
  {
    value: 'default',
    label: 'Select SMS Operation',
  },
  {
    value: 'single',
    label: 'Single SMS',
  },
  {
    value: 'schedule',
    label: 'Schedule SMS',
  },
  {
    value: 'blacklist',
    label: 'BlackList Number',
  },
  {
    value: 'notification',
    label: 'System Notification',
  },
  {
    value: 'automated',
    label: 'Automated SMS',
  },
];

function SendMessages(props) {
  const today = moment().format('YYYY-MM-DD');
  const { mobile } = isAuthenticated();
  const [selectedFromDate, setSelectedFromDate] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );
  const [selectedToDate, setSelectedToDate] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );

  const [scheduleDateTime, setScheduleDateTime] = React.useState(
    moment(today).format('YYYY-MM-DD HH:mm')
  );

  const [message, setMessage] = React.useState('');
  const [smsType, setSmsType] = React.useState('default');
  const [limitFrom, setLimitFrom] = React.useState(0);
  const [limitTo, setLimitTo] = React.useState(0);
  console.log(moment(scheduleDateTime).format('YYYY-MM-DD HH:mm'));
  const [others, setOthers] = React.useState('none');
  const [phoneNumber, setPhoneNumber] = React.useState('');
  const [blackListPhoneNumber, setBlackListPhoneNumber] = React.useState('');
  const [confirmDialog, setConfirmDialog] = React.useState({
    isOpen: false,
    title: '',
    subtitle: '',
  });
  const [rows, setRows] = React.useState([]);
  const [loading, setLoading] = React.useState(false);
  const [mounting, setMounting] = React.useState(false);
  const [refresh, setRefresh] = React.useState(false);
  const [alertMessage, setAlertMessage] = React.useState('');
  const [openAlert, setOpenAlert] = React.useState(false);
  const [error, setError] = React.useState(false);
  const [companyIDMapping, setCompanyIDMapping] = React.useState();
  const [filterMessagePlatform, setFilterMessagePlatform] = React.useState(1);

  const handleAlertClose = (event, reason) => {
    if (reason === 'clickaway') {
      return;
    }

    setOpenAlert(false);
  };

  React.useEffect(() => {
    const fetchData = async () => {
      setMounting(true);
      const res = await fetch(`${API}/api/company-ID-mappings`, {
        method: 'POST', // or 'PUT'
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ mobile }),
      });
      const json = await res.json();
      setCompanyIDMapping(json);
      setMounting(false);
    };
    fetchData();
  }, []);

  const handleFromDateChange = (date) => {
    setSelectedFromDate(date);
  };

  const handleToDateChange = (date) => {
    setSelectedToDate(date);
  };

  const handleSMSChange = (e) => {
    setMessage(e.target.value);
  };

  const handleSMSTypeChange = (event) => {
    setSmsType(event.target.value);
  };

  const handleOthersDropDownChange = (event) => {
    setOthers(event.target.value);
  };

  const handleInputFieldChange = (e) => {
    setBlackListPhoneNumber(e.target.value);
  };

  const handleInputFieldLimitFromChange = (e) => {
    setLimitFrom(e.target.value);
  };

  const handleInputFieldLimitToChange = (e) => {
    setLimitTo(e.target.value);
  };

  const handleInputFieldSingleSMSChange = (e) => {
    setPhoneNumber(e.target.value);
  };

  const handleInputFieldBlackListChange = (e) => {
    setBlackListPhoneNumber(e.target.value);
  };

  const handleScheduleDateChange = (date) => {
    setScheduleDateTime(date);
  };

  const sentMessageFilterByPlatform = async (e) => {
    setFilterMessagePlatform(e.target.value);
  };

  React.useEffect(() => {
    const fetchData = async () => {
      setMounting(true);
      const res = await fetch(`${API}/api/scheduled-messages`);
      const json = await res.json();
      setRows(json);
      setMounting(false);
    };
    fetchData();
  }, [refresh]);

  //Filter records
  const filterData = async () => {
    setLoading(true);
    const res = await fetch(`${API}/api/filter/scheduled-messages`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ From: selectedFromDate, To: selectedToDate }),
    });
    const json = await res.json();
    setRows(json);
    setLoading(false);
  };

  //BlackList By Platform and Number
  const blackListNumberAndPlatform = async (mobile, platform) => {
    setLoading(true);
    const res = await fetch(`${API}/api/black-list-mobile-on-platform`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ mobile: mobile, platform: platform }),
    });
    const json = await res.json();
    setLoading(false);
    // console.log(json);
    if (!json.message) {
      setError(true);
      setAlertMessage('Error BlackListing Mobile');
      setOpenAlert(true);
    } else {
      setError(false);
      setAlertMessage(json.message);
      setOpenAlert(true);
    }
    setConfirmDialog({ ...confirmDialog, isOpen: false });
  };

  //Schedule SMS
  const scheduleSMS = async (
    date,
    time,
    msg,
    platform,
    category,
    limitFrom,
    limitTo
  ) => {
    setLoading(true);
    const res = await fetch(`${API}/api/send-scheduled-sms`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({
        date: date,
        time: time,
        msg: msg,
        platform: platform,
        category: category,
        limitFrom: limitFrom,
        limitTo: limitTo,
      }),
    });
    const json = await res.json();
    setLoading(false);
    // console.log(json);
    if (!json.message) {
      setError(true);
      setAlertMessage(json.error);
      setOpenAlert(true);
    } else {
      setError(false);
      setAlertMessage(json.message);
      setOpenAlert(true);
    }
    setConfirmDialog({ ...confirmDialog, isOpen: false });
    setRefresh(!refresh);
  };

  //Send System Notification
  const sentSystemNotification = async (msg) => {
    setLoading(true);
    const res = await fetch(`${API}/api/send-system-notification`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ msg: msg }),
    });
    const json = await res.json();
    setLoading(false);
    // console.log(json);
    if (!json.message) {
      setError(true);
      setAlertMessage('Error Sending System Notification');
      setOpenAlert(true);
    } else {
      setError(false);
      setAlertMessage(json.message);
      setOpenAlert(true);
    }
    setConfirmDialog({ ...confirmDialog, isOpen: false });
  };

  //Send Single SMS
  const sendSingleSMS = async (msg, mobile, platform) => {
    setLoading(true);
    const res = await fetch(`${API}/api/send-single-sms`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ msg: msg, platform: platform, mobile: mobile }),
    });
    const json = await res.json();
    setLoading(false);
    // console.log(json);
    if (!json.message) {
      setError(true);
      setAlertMessage('Error Sending Single SMS');
      setOpenAlert(true);
    } else {
      setError(false);
      setAlertMessage(json.message);
      setOpenAlert(true);
    }
    setConfirmDialog({ ...confirmDialog, isOpen: false });
  };

  //Stop Message
  const stopMessage = async (ID) => {
    setLoading(true);
    const res = await fetch(`${API}/api/stop-sms`, {
      method: 'DELETE', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ ID: ID }),
    });
    setLoading(false);
    const json = await res.json();
    // console.log(json);
    if (!json.message) {
      setError(true);
      setAlertMessage('Error Stopping Message');
      setOpenAlert(true);
    } else {
      setError(true);
      setAlertMessage(json.message);
      setOpenAlert(true);
    }
    setConfirmDialog({ ...confirmDialog, isOpen: false });
    setRefresh(!refresh);
  };

  const copyActionIcon = (row) => (
    <Tooltip title="Copy Message">
      <IconButton
        onClick={() => {
          copy(row.SMS_Text);
          setError(false);
          setAlertMessage('Message Copied To Clipboard');
          setOpenAlert(true);
        }}
        style={{ color: 'green' }}
        size="small"
      >
        <FileCopyRounded />
      </IconButton>
    </Tooltip>
  );

  const viewActionIcon = (row) => (
    <Tooltip title="View Message">
      <IconButton
        onClick={() => alert(row.SMS_Text)}
        style={{ color: 'blue' }}
        size="small"
      >
        <VisibilityRounded />
      </IconButton>
    </Tooltip>
  );

  const stopActionIcon = (row) => (
    <Tooltip title="Stop Message">
      <IconButton
        style={{ color: 'red' }}
        size="small"
        onClick={() => {
          setConfirmDialog({
            isOpen: true,
            title: 'Are you sure you want to stop this Message?',
            subtitle: "You can't undo this operation",
            onConfirm: () => {
              stopMessage(row.id);
            },
          });
        }}
      >
        <BlockRounded />
      </IconButton>
    </Tooltip>
  );

  const actionIconsArray = [viewActionIcon, stopActionIcon, copyActionIcon];

  return (
    <>
      <ActivityIndicator visible={loading} />
      <ViewContainer icon={<ScheduleRounded />} title="Message Scheduler">
        <Grid container spacing={1}>
          <Grid item container spacing={1}>
            <Grid item xs={2}>
              <TextField
                fullWidth
                id="outlined-select-smsType"
                select
                value={smsType}
                onChange={handleSMSTypeChange}
                variant="outlined"
                size="small"
              >
                {smsTypes.map((option) => (
                  <MenuItem key={option.value} value={option.value}>
                    {option.label}
                  </MenuItem>
                ))}
              </TextField>
            </Grid>
            {smsType === 'single' ? (
              <>
                <Grid item xs={12} sm={2} md={2}>
                  <CustomDropDown
                    fullWidth
                    variant="outlined"
                    size="small"
                    label="Select PlatForm"
                    selectedValue={filterMessagePlatform}
                    handleChange={sentMessageFilterByPlatform}
                    data={companyIDMapping}
                  />
                </Grid>
                <Grid item xs={12} sm={3} md={3}>
                  <CustomInputField
                    label="Enter Mobile Number"
                    variant="outlined"
                    size="small"
                    placeholder="Enter mobile number"
                    onChange={handleInputFieldSingleSMSChange}
                  />
                </Grid>
              </>
            ) : null}
            {smsType === 'blacklist' ? (
              <>
                <Grid item>
                  <CustomDropDown
                    variant="outlined"
                    size="small"
                    label="Select PlatForm"
                    selectedValue={filterMessagePlatform}
                    handleChange={sentMessageFilterByPlatform}
                    data={companyIDMapping}
                  />
                </Grid>
                <Grid item>
                  <CustomInputField
                    label="Black List Mobile"
                    variant="outlined"
                    size="small"
                    placeholder="Enter mobile number"
                    onChange={handleInputFieldBlackListChange}
                  />
                </Grid>
              </>
            ) : null}
            {smsType === 'schedule' ? (
              <>
                <Grid item xs={12} sm={3} md={3}>
                  <CustomDateTimePicker
                    helperText="Select Schedule Date"
                    handleDateTimeChange={handleScheduleDateChange}
                    selectedDate={scheduleDateTime}
                  />
                </Grid>
                <Grid item xs={12} sm={2} md={2}>
                  <CustomDropDown
                    variant="outlined"
                    size="small"
                    label="Select PlatForm"
                    selectedValue={filterMessagePlatform}
                    handleChange={sentMessageFilterByPlatform}
                    data={companyIDMapping}
                  />
                </Grid>
                <Grid item xs={12} sm={2} md={2}>
                  <CustomInputField
                    label="Limit From"
                    variant="outlined"
                    size="small"
                    required
                    placeholder="Enter Limit From"
                    onChange={handleInputFieldLimitFromChange}
                  />
                </Grid>
                <Grid item xs={12} sm={1} md={1}>
                  <CustomInputField
                    label="Limit To"
                    variant="outlined"
                    size="small"
                    placeholder="Enter Limit To"
                    required
                    onChange={handleInputFieldLimitToChange}
                  />
                </Grid>
                <Grid item xs={12} sm={2} md={2}>
                  <CustomDropDown
                    variant="outlined"
                    size="small"
                    label="Select"
                    required
                    selectedValue={others}
                    handleChange={handleOthersDropDownChange}
                    data={someOtherInfo}
                  />
                </Grid>
              </>
            ) : null}
            {smsType === 'automated' ? (
              <>
                <Grid item xs={3}>
                  <CustomDateTimePicker
                    helperText="Select Schedule Date"
                    handleDateTimeChange={handleScheduleDateChange}
                    selectedDate={scheduleDateTime}
                  />
                </Grid>
                <Grid item xs={2}>
                  <CustomDropDown
                    variant="outlined"
                    size="small"
                    label="Select PlatForm"
                    selectedValue={filterMessagePlatform}
                    handleChange={sentMessageFilterByPlatform}
                    data={companyIDMapping}
                  />
                </Grid>
                <Grid item xs={2}>
                  <CustomInputField
                    label="Limit From"
                    variant="outlined"
                    size="small"
                    placeholder="Enter Limit From"
                    onChange={handleInputFieldChange}
                  />
                </Grid>
                <Grid item xs={2}>
                  <CustomInputField
                    label="Limit To"
                    variant="outlined"
                    size="small"
                    placeholder="Enter Limit To"
                    onChange={handleInputFieldChange}
                  />
                </Grid>
                <Grid item xs={2}>
                  <CustomDropDown
                    variant="outlined"
                    size="small"
                    label="Select"
                    selectedValue={others}
                    handleChange={handleOthersDropDownChange}
                    data={someOtherInfo}
                  />
                </Grid>
              </>
            ) : null}
          </Grid>
          <Grid item xs={12}>
            {smsType === 'default' ? null : (
              <>
                <TextField
                  fullWidth
                  multiline
                  required
                  rows={5}
                  value={message}
                  onChange={handleSMSChange}
                  id="outlined-secondary"
                  label="Type your SMS here"
                  variant="outlined"
                  color="primary"
                  disabled={smsType === 'blacklist' ? true : false}
                />
                <Typography>
                  Characters: {message.length} Messages:{' '}
                  {Math.ceil(message.length / 160)}
                </Typography>
              </>
            )}
            <Grid
              item
              container
              style={{ display: 'flex', justifyContent: 'flex-end' }}
            >
              {smsType === 'default' ? null : (
                <Grid item xs={12} sm={2} md={2}>
                  <Button
                    color="primary"
                    variant="contained"
                    fullWidth
                    size="small"
                    disabled={false}
                    onClick={() => {
                      smsType === 'blacklist'
                        ? setConfirmDialog({
                            isOpen: true,
                            title:
                              'Are you sure you want Black List Entered Number On the Chosen Platform?',
                            // subtitle: "You can't undo this operation",
                            onConfirm: () => {
                              blackListNumberAndPlatform(
                                blackListPhoneNumber,
                                filterMessagePlatform
                              );
                            },
                          })
                        : smsType === 'notification'
                        ? setConfirmDialog({
                            isOpen: true,
                            title:
                              'Are you sure you want To Send The System Notification?',
                            subtitle: "You can't undo this operation",
                            onConfirm: () => {
                              sentSystemNotification(message);
                            },
                          })
                        : smsType === 'single'
                        ? setConfirmDialog({
                            isOpen: true,
                            title: 'Are you sure you want to Send the SMS?',
                            subtitle: "You can't undo this operation",
                            onConfirm: () => {
                              sendSingleSMS(
                                message,
                                phoneNumber,
                                filterMessagePlatform
                              );
                            },
                          })
                        : smsType === 'schedule'
                        ? setConfirmDialog({
                            isOpen: true,
                            title: 'Are you sure you want to Schdule the SMS?',
                            // subtitle: "You can't undo this operation",
                            onConfirm: () => {
                              scheduleSMS(
                                moment(scheduleDateTime).format('YYYY-MM-DD'),
                                moment(scheduleDateTime).format('HH:mm'),
                                encodeURIComponent(message),
                                filterMessagePlatform,
                                others,
                                limitFrom,
                                limitTo
                              );
                            },
                          })
                        : alert('Not yet told what to do');
                    }}
                  >
                    {smsType === 'single'
                      ? 'Send Single SMS'
                      : smsType === 'schedule'
                      ? 'Schedule SMS'
                      : smsType === 'blacklist'
                      ? 'Black List Number'
                      : smsType === 'notification'
                      ? 'Send Notification'
                      : smsType === 'automated'
                      ? 'Schedule Automated'
                      : 'null'}
                  </Button>
                </Grid>
              )}
            </Grid>
          </Grid>
          <Grid item xs={12}>
            <Divider
              style={{ color: 'green', margin: 10, fontWeight: 'bold' }}
            />
            <ViewContainer
              icon={<PhonelinkLockRounded />}
              title="Scheduled SMS's"
            >
              {mounting ? (
                <>
                  <Skeleton variant="text" />
                  <Skeleton variant="text" />
                  <Skeleton variant="text" />
                  <Skeleton variant="text" />
                  <Skeleton variant="text" />

                  <Skeleton
                    variant="rect"
                    width="100%"
                    height={518}
                    animation="wave"
                  />
                </>
              ) : (
                <>
                  <Grid
                    container
                    spacing={2}
                    style={{ display: 'flex', justifyContent: 'flex-end' }}
                  >
                    <Grid item xs={12} md={3} sm={3}>
                      <CustomDatePicker
                        selectedDate={selectedFromDate}
                        handleDateChange={handleFromDateChange}
                        label="Select Start Date"
                      />
                    </Grid>
                    <Grid item xs={12} md={3} sm={3}>
                      <CustomDatePicker
                        selectedDate={selectedToDate}
                        handleDateChange={handleToDateChange}
                        label="Select End Date"
                      />
                    </Grid>
                    <Grid item xs={12} md={3} sm={3}>
                      <Button
                        variant="contained"
                        color="primary"
                        style={{ top: '1rem', width: 100 }}
                        size="medium"
                        onClick={() => setRefresh(!refresh)}
                      >
                        Refresh
                      </Button>
                    </Grid>
                    <Grid item xs={12} md={3} sm={3}>
                      <Button
                        variant="contained"
                        color="primary"
                        style={{ top: '1rem', width: 100 }}
                        size="medium"
                        onClick={filterData}
                      >
                        Filter
                      </Button>
                    </Grid>
                  </Grid>
                  <CustomTable
                    rows={rows}
                    columns={columns}
                    actions={true}
                    actionIcons={actionIconsArray}
                  />
                </>
              )}
            </ViewContainer>
          </Grid>
        </Grid>
      </ViewContainer>
      <CustomConfirmDialog confirmDialog={confirmDialog}>
        <Button
          variant="outlined"
          color="primary"
          onClick={() => setConfirmDialog({ isOpen: false })}
        >
          No
        </Button>
        <Button
          variant="contained"
          color="secondary"
          onClick={() => {
            confirmDialog.onConfirm();
          }}
        >
          Yes
        </Button>
      </CustomConfirmDialog>
      <CustomSnackBar
        vertical="top"
        horizontal="right"
        severity={error ? 'error' : 'success'}
        open={openAlert}
        handleClose={handleAlertClose}
        hideDuration={6000}
        message={alertMessage}
      />
    </>
  );
}

export default SendMessages;
