import { Button, Grid, IconButton, Tooltip } from '@material-ui/core';
import React from 'react';
import CustomDatePicker from './CustomDatePicker';
import ViewContainer from './ViewContainer';
import CustomTable from './CustomTable';
import { MessageRounded, VisibilityRounded } from '@material-ui/icons';
import CustomDropDown from './CustomDropDown';
import { API } from '../config';
import ActivityIndicator from './ActivityIndicator';
import { Skeleton } from '@material-ui/lab';
import { isAuthenticated } from '../API';
const moment = require('moment');

const columns = [
  { id: 'ID', label: 'ID', minWidth: 20 },
  { id: 'Date', label: 'Date', minWidth: 100 },
  {
    id: 'Mobile',
    label: 'Mobile\u00a0Number',
    minWidth: 100,
    format: (value) => value.toLocaleString('en-US'),
  },
  {
    id: 'Msg_Type',
    label: 'Platform',
    minWidth: 100,
    format: (value) => value.toLocaleString('en-US'),
  },
  {
    id: 'Response',
    label: 'Status',
    minWidth: 100,
    format: (value) => value.toLocaleString('en-US'),
  },
];

function SentMessages(props) {
  const today = moment().format('YYYY-MM-DD');
  const { mobile } = isAuthenticated();

  const [msg, setMsg] = React.useState('');
  const [companyIDMapping, setCompanyIDMapping] = React.useState();
  const [filterMessagePlatform, setFilterMessagePlatform] = React.useState(1);
  const [selectedFromDate, setSelectedFromDate] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );
  const [selectedToDate, setSelectedToDate] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );

  const [rows, setRows] = React.useState([]);
  const [loading, setLoading] = React.useState(false);
  const [mounting, setMounting] = React.useState(false);
  const [refresh, setRefresh] = React.useState(false);

  React.useEffect(() => {
    const fetchData = async () => {
      setMounting(true);
      const res = await fetch(`${API}/api/company-ID-mappings`, {
        method: 'POST', // or 'PUT'
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ mobile }),
      });
      const json = await res.json();
      setCompanyIDMapping(json);
      setMounting(false);
    };
    fetchData();
  }, []);

  React.useEffect(() => {
    const fetchData = async () => {
      setMounting(true);
      const res = await fetch(`${API}/api/sent-messages`);
      const json = await res.json();
      setRows(json);
      setMounting(false);
    };
    fetchData();
  }, [refresh]);

  const viewActionIcon = (row) => (
    <Tooltip title="View Message">
      <IconButton
        onClick={() => alert(row.Out_Text)}
        style={{ color: 'blue' }}
        size="small"
      >
        <VisibilityRounded />
      </IconButton>
    </Tooltip>
  );

  const actionIconsArray = [viewActionIcon];

  // //Show SentMessage
  // const showSentMessage = async (ID) => {
  //   // setLoading(true);
  //   const res = await fetch(`${API}/api/show/sent-message`, {
  //     method: 'POST', // or 'PUT'
  //     headers: {
  //       'Content-Type': 'application/json',
  //     },
  //     body: JSON.stringify({
  //       ID: ID,
  //     }),
  //   });
  //   const json = await res.json();
  //   setMsg(json[0]);
  //   alert(msg);
  //   // setLoading(false);
  // };

  //Filter records
  const filterData = async () => {
    setLoading(true);
    const res = await fetch(`${API}/api/filter/sent-messages`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ From: selectedFromDate, To: selectedToDate }),
    });
    const json = await res.json();
    setRows(json);
    setLoading(false);
  };

  //Filter Bulk Usage
  const sentMessageFilterByPlatform = async (e) => {
    setFilterMessagePlatform(e.target.value);
    // console.log();
    setLoading(true);
    const res = await fetch(`${API}/api/filter/sent-message/by-platform`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({
        company: e.target.value,
      }),
    });
    const json = await res.json();
    setRows(json);
    setLoading(false);
  };

  const handleFromDateChange = (date) => {
    setSelectedFromDate(date);
  };

  const handleToDateChange = (date) => {
    setSelectedToDate(date);
  };

  // const handleDropDownChange = (event) => {
  //   setPlatForm(event.target.value);
  // };

  const handleFilterBulkDropDownChange = (event) => {
    setFilterMessagePlatform(event.target.value);
  };

  return (
    <>
      <ActivityIndicator visible={loading} />
      <ViewContainer icon={<MessageRounded />} title="Sent Messages">
        {mounting ? (
          <>
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />

            <Skeleton
              variant="rect"
              width="100%"
              height={518}
              animation="wave"
            />
          </>
        ) : (
          <>
            <Grid
              container
              spacing={2}
              style={{ display: 'flex', justifyContent: 'flex-end' }}
            >
              <Grid item>
                <CustomDropDown
                  variant="outlined"
                  size="small"
                  label="Select PlatForm"
                  style={{ top: '1rem', marginRight: '10px', width: '10rem' }}
                  selectedValue={filterMessagePlatform}
                  handleChange={sentMessageFilterByPlatform}
                  data={companyIDMapping}
                />
              </Grid>
              <Grid item>
                <CustomDatePicker
                  selectedDate={selectedFromDate}
                  handleDateChange={handleFromDateChange}
                  label="Select Start Date"
                />
              </Grid>
              <Grid item>
                <CustomDatePicker
                  selectedDate={selectedToDate}
                  handleDateChange={handleToDateChange}
                  label="Select End Date"
                />
              </Grid>
              <Grid item>
                <Button
                  variant="contained"
                  color="primary"
                  style={{ top: '1rem', width: 100 }}
                  size="medium"
                  onClick={() => setRefresh(!refresh)}
                >
                  Refresh
                </Button>
              </Grid>
              <Grid item>
                <Button
                  variant="contained"
                  color="primary"
                  style={{ top: '1rem', width: 100 }}
                  size="medium"
                  onClick={filterData}
                >
                  Filter
                </Button>
              </Grid>
            </Grid>
            <CustomTable
              rows={rows}
              columns={columns}
              actions={true}
              actionIcons={actionIconsArray}
            />
          </>
        )}
      </ViewContainer>
    </>
  );
}

export default SentMessages;
