import {
  Button,
  Card,
  CardActionArea,
  CardActions,
  CardContent,
  CardMedia,
  Grid,
  Typography,
} from '@material-ui/core';
import { ListAltOutlined } from '@material-ui/icons';
import React from 'react';
import CustomDatePicker from './CustomDatePicker';
import CustomInputField from './CustomInputField';
import ViewContainer from './ViewContainer';
import CustomTable from './CustomTable';
import CustomDropDown from './CustomDropDown';
import Lottie from 'react-lottie';
import winner from '../assets/winner.json';
import authorize from '../assets/authorize.json';
const moment = require('moment');

const columns = [
  { id: 'id', label: 'Name', maxWidth: 20 },
  { id: 'SMS_Date', label: 'Mobile', minWidth: 50 },
  {
    id: 'SMS_Time',
    label: 'Date',
    minWidth: 50,
  },
  {
    id: 'SMS_Type',
    label: 'Ticket',
    minWidth: 50,
  },
  {
    id: 'SMS_Status',
    label: 'Platform',
    minWidth: 50,
  },
  {
    id: 'SMS_Status',
    label: 'Amount',
    minWidth: 50,
  },
  {
    id: 'SMS_Status',
    label: 'Status',
    minWidth: 50,
  },
];

const currencies = [
  {
    value: 'USD',
    label: 'Dairy Pesa',
  },
  {
    value: 'EUR',
    label: 'Pesa Shambani',
  },
  {
    value: 'BTC',
    label: 'Bambika',
  },
  {
    value: 'JPY',
    label: 'Dream Life',
  },
];

const statusesData = [
  {
    value: 'sent',
    label: 'Sent',
  },
  {
    value: 'pending',
    label: 'Pending',
  },
];

const winnerDefaultOptions = {
  loop: true,
  autoplay: true,
  animationData: winner,
  rendererSettings: {
    preserveAspectRatio: 'xMidYMid slice',
  },
};

const authorizeDefaultOptions = {
  loop: true,
  autoplay: true,
  animationData: authorize,
  rendererSettings: {
    preserveAspectRatio: 'xMidYMid slice',
  },
};

function SuperNova(props) {
  const today = moment().format('YYYY-MM-DD');
  const [selectedFromDate, setSelectedFromDate] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );
  const [selectedToDate, setSelectedToDate] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );

  const [scheduleDateTime, setScheduleDateTime] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );

  const [message, setMessage] = React.useState('');
  const [smsType, setSmsType] = React.useState('default');
  const [platform, setPlatForm] = React.useState('Select PlatForm');
  const [status, setStatuses] = React.useState('Sort By Status');
  const [others, setOthers] = React.useState('None');
  const [phoneNumber, setPhoneNumber] = React.useState('');

  const [rows, setRows] = React.useState([]);
  const [loading, setLoading] = React.useState(false);
  const [mounting, setMounting] = React.useState(false);
  const [refresh, setRefresh] = React.useState(false);

  const handleFromDateChange = (date) => {
    setSelectedFromDate(date);
  };

  const handleToDateChange = (date) => {
    setSelectedToDate(date);
  };

  const handleInputFieldChange = (e) => {
    setPhoneNumber(e.target.value);
  };

  const handleDropDownChange = (event) => {
    setPlatForm(event.target.value);
  };

  const handleStatusDropDownChange = (event) => {
    setStatuses(event.target.value);
  };

  const searchDataOnEnter = (event) => {
    if (event.key === 'Enter') {
      // Do code here
      event.preventDefault();
      if (phoneNumber.length >= 10) {
        // searchDataByMobile(phoneNumber);
      }
    }
  };

  return (
    <ViewContainer icon={<ListAltOutlined />} title="SuperNova W">
      <Grid container spacing={2}>
        <Grid item xs={12} md={6}>
          <Card
            style={{ width: '90%', minHeight: 100, padding: 10, margin: 10 }}
            elevation={1}
          >
            <CardActionArea>
              <Lottie options={winnerDefaultOptions} height={100} width={80} />
              <CardContent>
                <Typography variant="h6" color="primary" align="center">
                  Pick Winners
                </Typography>
              </CardContent>
            </CardActionArea>
            <CardActions>
              <Grid container>
                <Grid item xs={12} md={6}>
                  <CustomDropDown
                    variant="outlined"
                    size="small"
                    label="Select PlatForm"
                    selectedValue={platform}
                    style={{ top: '1rem' }}
                    handleChange={handleDropDownChange}
                    data={currencies}
                  />
                </Grid>
                <Grid item xs={12} md={6}>
                  <CustomDatePicker
                    selectedDate={selectedToDate}
                    handleDateChange={handleToDateChange}
                    label="Select End Date"
                  />
                </Grid>
                <Grid item xs={12}>
                  <Button variant="contained" color="primary" fullWidth>
                    Pick Winners
                  </Button>
                </Grid>
              </Grid>
            </CardActions>
          </Card>
        </Grid>
        <Grid item xs={12} md={6}>
          <Card
            style={{ width: '90%', minHeight: 100, padding: 10, margin: 10 }}
            elevation={1}
          >
            <CardActionArea>
              <Lottie
                options={authorizeDefaultOptions}
                height={100}
                width={80}
              />
              <CardContent>
                <Typography variant="h6" color="primary" align="center">
                  Authorize Winners
                </Typography>
              </CardContent>
            </CardActionArea>
            <CardActions>
              <Grid container>
                <Grid item xs={12}>
                  <CustomInputField
                    label="Enter OTP"
                    variant="outlined"
                    size="small"
                    placeholder="Enter OTP"
                    fullWidth
                    style={{
                      top: '1rem',
                      marginBottom: '1.5rem',
                    }}
                    onChange={handleInputFieldChange}
                    onKeyDown={searchDataOnEnter}
                  />
                  <Grid item xs={12}>
                    <Button variant="contained" color="primary" fullWidth>
                      Authorize Winners
                    </Button>
                  </Grid>
                </Grid>
              </Grid>
            </CardActions>
          </Card>
        </Grid>
        <Grid item xs={12}>
          <>
            <Grid
              container
              spacing={2}
              style={{ display: 'flex', justifyContent: 'flex-end' }}
            >
              <Grid item xs={12} md={2}>
                <CustomInputField
                  label="Search By Mobile"
                  variant="outlined"
                  size="small"
                  placeholder="Enter Mobile"
                  style={{ top: '1rem' }}
                  onChange={handleInputFieldChange}
                  onKeyDown={searchDataOnEnter}
                />
              </Grid>
              <Grid item xs={12} md={2}>
                <CustomDropDown
                  variant="outlined"
                  size="small"
                  label="Select PlatForm"
                  selectedValue={platform}
                  style={{ top: '1rem' }}
                  handleChange={handleDropDownChange}
                  data={currencies}
                />
              </Grid>
              <Grid item xs={12} md={2}>
                <CustomDropDown
                  variant="outlined"
                  size="small"
                  label="Select Status"
                  style={{ top: '1rem' }}
                  selectedValue={status}
                  handleChange={handleStatusDropDownChange}
                  data={statusesData}
                  fullWidth
                />
              </Grid>
              <Grid item xs={12} md={2}>
                <CustomDatePicker
                  selectedDate={selectedFromDate}
                  handleDateChange={handleFromDateChange}
                  label="Select Start Date"
                />
              </Grid>
              <Grid item xs={12} md={2}>
                <CustomDatePicker
                  selectedDate={selectedToDate}
                  handleDateChange={handleToDateChange}
                  label="Select End Date"
                  fullWidth
                />
              </Grid>
              <Grid item>
                <Button
                  variant="contained"
                  color="primary"
                  style={{
                    top: '1rem',
                    bottom: '1rem',
                    width: 100,
                    marginBottom: 10,
                  }}
                  size="medium"
                  onClick={() => setRefresh(!refresh)}
                >
                  Refresh
                </Button>
              </Grid>
              <Grid item>
                <Button
                  variant="contained"
                  color="primary"
                  style={{ bottom: '1rem', width: 100 }}
                  size="medium"
                  // onClick={filterData}
                >
                  Filter
                </Button>
              </Grid>
            </Grid>
            <CustomTable rows={rows} columns={columns} />
          </>
        </Grid>
      </Grid>
    </ViewContainer>
  );
}

export default SuperNova;
