import { Button, Grid, IconButton, Tooltip } from '@material-ui/core';
import {
  Lock,
  DeleteForeverOutlined,
  EditRounded,
  LockOpenRounded,
  PeopleAltRounded,
  AddCircleRounded,
} from '@material-ui/icons';
import React from 'react';
import CustomTable from './CustomTable';
import { API } from '../config';
import ViewContainer from './ViewContainer';
import { Skeleton } from '@material-ui/lab';
import CustomModal from './CustomModal';
import EditSystemOperator from './Forms/EditSystemOperator';
import AddSystemOperator from './Forms/AddSystemOperator';
import CustomConfirmDialog from './CustomConfirmDialog';
import CustomSnackBar from './CustomSnackBar';

const columns = [
  { id: 'Firstname', label: 'First\u00a0Name', minWidth: 50 },
  { id: 'Lastname', label: 'Last\u00a0Name', minWidth: 100 },
  {
    id: 'Status',
    label: 'Status',
    minWidth: 100,
  },
];

function SystemOperators() {
  const [openPopup, setOpenPopup] = React.useState(false);
  const [edit, setEdit] = React.useState(false);
  const [add, setAdd] = React.useState(false);
  const [alertMessage, setAlertMessage] = React.useState('');
  const [error, setError] = React.useState(false);
  const [refresh, setRefresh] = React.useState(false);
  const [openAlert, setOpenAlert] = React.useState(false);
  const [confirmDialog, setConfirmDialog] = React.useState({
    isOpen: false,
    title: '',
    subtitle: '',
  });
  const [formData, setFormData] = React.useState({
    firstName: '',
    lastName: '',
    role: '',
    ID: '',
    platforms: '',
  });
  const [rows, setRows] = React.useState([]);
  const [loading, setLoading] = React.useState(false);

  const handleAlertClose = (event, reason) => {
    if (reason === 'clickaway') {
      return;
    }

    setOpenAlert(false);
  };

  React.useEffect(() => {
    const fetchData = async () => {
      setLoading(true);
      const res = await fetch(`${API}/api/system-users`);
      const json = await res.json();
      setRows(json);
      setLoading(false);
    };
    fetchData();
  }, [refresh]);

  //Delete System User
  const deleteData = async (ID) => {
    setLoading(true);
    const res = await fetch(`${API}/api/delete-system-user`, {
      method: 'DELETE', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ ID }),
    });
    setLoading(false);
    const json = await res.json();
    // console.log(json);
    if (!json.message) {
      setError(true);
      setAlertMessage('Error Deleting Platform Account');
      setOpenAlert(true);
    } else {
      setError(true);
      setAlertMessage(json.message);
      setOpenAlert(true);
    }
    setConfirmDialog({ ...confirmDialog, isOpen: false });
  };

  //Block System User
  const blockUser = async (status, ID) => {
    setLoading(true);
    const res = await fetch(`${API}/api/block-system-user`, {
      method: 'PUT', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({ status, ID }),
    });
    setLoading(false);
    const json = await res.json();
    // console.log(json);
    if (!json.message) {
      setError(true);
      setAlertMessage('Error Blocking User');
      setOpenAlert(true);
    } else {
      setError(true);
      setAlertMessage(json.message);
      setOpenAlert(true);
    }
    setConfirmDialog({ ...confirmDialog, isOpen: false });
    setRefresh(!refresh);
  };

  const editActionIcon = (row) => (
    <Tooltip title="Edit User">
      <IconButton
        onClick={() => {
          setOpenPopup(!openPopup);
          setFormData({
            ...formData,
            firstName: row.Firstname,
            lastName: row.Lastname,
            role: row.User_Type,
            ID: row.ID,
            platforms: row.Platforms,
          });
          setEdit(true);
        }}
        style={{ color: 'blue' }}
        size="small"
      >
        <EditRounded />
      </IconButton>
    </Tooltip>
  );

  const deleteActionIcon = (row) => (
    <Tooltip title="Delete User">
      <IconButton
        style={{ color: 'red' }}
        size="small"
        onClick={() => {
          setConfirmDialog({
            isOpen: true,
            title: 'Are you sure you want to delete this operator?',
            subtitle: "You can't undo this operation",
            onConfirm: () => {
              deleteData(row.ID);
              setRefresh(!refresh);
            },
          });
        }}
      >
        <DeleteForeverOutlined />
      </IconButton>
    </Tooltip>
  );

  const blockUnblockActionIcon = (row) => (
    <Tooltip
      title={row.Status === 'Active' ? 'Block User' : 'Unblock User'}
      size="small"
    >
      <IconButton
        style={{ color: row.Status === 'Active' ? 'green' : 'red' }}
        onClick={() => {
          setConfirmDialog({
            isOpen: true,
            title: 'Are you sure you want to Block this operator?',
            // subtitle: "You can't undo this operation",
            onConfirm: () => {
              let newStatus = row.Status === 'Active' ? 'Inactive' : 'Active';
              blockUser(newStatus, row.ID);
            },
          });
        }}
      >
        {row.Status === 'Active' ? <LockOpenRounded /> : <Lock />}
      </IconButton>
    </Tooltip>
  );

  const actionIconsArray = [
    editActionIcon,
    blockUnblockActionIcon,
    deleteActionIcon,
  ];

  return (
    <>
      <ViewContainer icon={<PeopleAltRounded />} title="System Users">
        {loading ? (
          <>
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />
            <Skeleton variant="text" />

            <Skeleton
              variant="rect"
              width="100%"
              height={518}
              animation="wave"
            />
          </>
        ) : (
          <>
            <Grid
              container
              spacing={2}
              style={{ display: 'flex', justifyContent: 'flex-end' }}
            >
              <Grid item>
                <Button
                  variant="contained"
                  color="primary"
                  startIcon={<AddCircleRounded />}
                  style={{ marginBottom: '10px' }}
                  onClick={() => {
                    setEdit(false);
                    setOpenPopup(!openPopup);
                    setAdd(true);
                  }}
                >
                  Add System User
                </Button>
              </Grid>
            </Grid>
            <CustomTable
              columns={columns}
              rows={rows}
              actions={true}
              actionIcons={actionIconsArray}
              rowCount={true}
            />
          </>
        )}
      </ViewContainer>
      <CustomModal
        openPopup={openPopup}
        setOpenPopup={setOpenPopup}
        title={
          edit ? 'Edit System Operator' : add ? 'Add System Operator' : 'Title'
        }
      >
        {edit ? (
          <EditSystemOperator
            setOpenPopup={setOpenPopup}
            setLoading={setLoading}
            openAlert={openAlert}
            setOpenAlert={setOpenAlert}
            setError={setError}
            setAlertMessage={setAlertMessage}
            setRefresh={setRefresh}
            refresh={refresh}
            editFormData={formData}
          />
        ) : add ? (
          <AddSystemOperator
            setOpenPopup={setOpenPopup}
            setRefresh={setRefresh}
            refresh={refresh}
          />
        ) : (
          'Testing'
        )}
      </CustomModal>
      <CustomConfirmDialog confirmDialog={confirmDialog}>
        <Button
          variant="outlined"
          color="primary"
          onClick={() => setConfirmDialog({ isOpen: false })}
        >
          No
        </Button>
        <Button
          variant="contained"
          color="secondary"
          onClick={() => {
            confirmDialog.onConfirm();
          }}
        >
          Yes
        </Button>
      </CustomConfirmDialog>
      <CustomSnackBar
        vertical="top"
        horizontal="right"
        severity={error ? 'error' : 'success'}
        open={openAlert}
        handleClose={handleAlertClose}
        hideDuration={6000}
        message={alertMessage}
      />
    </>
  );
}

export default SystemOperators;
