import { Button, Grid } from '@material-ui/core';
import { ConfirmationNumberRounded } from '@material-ui/icons';
import { Skeleton } from '@material-ui/lab';
import React from 'react';
import CustomDatePicker from './CustomDatePicker';
import CustomInputField from './CustomInputField';
import ViewContainer from './ViewContainer';
const moment = require('moment');

function Tickets(props) {
  const today = moment().format('YYYY-MM-DD');
  const [rows, setRows] = React.useState([]);
  const [loading, setLoading] = React.useState(false);
  const [mounting, setMounting] = React.useState(false);
  const [refresh, setRefresh] = React.useState(false);
  const [phoneNumber, setPhoneNumber] = React.useState('');

  const [selectedFromDate, setSelectedFromDate] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );
  const [selectedToDate, setSelectedToDate] = React.useState(
    moment(today).format('YYYY-MM-DD')
  );

  React.useEffect(() => {
    setMounting(true);
    setMounting(false);
  }, []);

  const handleFromDateChange = (date) => {
    setSelectedFromDate(date);
  };

  const handleInputFieldChange = (e) => {
    setPhoneNumber(e.target.value);
  };

  const handleToDateChange = (date) => {
    setSelectedToDate(date);
  };

  const searchDataOnEnter = (event) => {
    if (event.key === 'Enter') {
      // Do code here
      event.preventDefault();
      if (phoneNumber.length >= 10) {
        // searchDataByMobile(phoneNumber);
      }
    }
  };

  return (
    <ViewContainer icon={<ConfirmationNumberRounded />} title="Tickets">
      {mounting ? (
        <>
          <Skeleton variant="text" />
          <Skeleton variant="text" />
          <Skeleton variant="text" />
          <Skeleton variant="text" />
          <Skeleton variant="text" />

          <Skeleton variant="rect" width="100%" height={518} animation="wave" />
        </>
      ) : (
        <>
          <Grid
            container
            spacing={2}
            style={{ display: 'flex', justifyContent: 'flex-end' }}
          >
            <Grid item>
              <CustomInputField
                label="Search Ticket"
                variant="outlined"
                size="small"
                placeholder="Enter Ticket"
                style={{ top: '1rem' }}
                onChange={handleInputFieldChange}
                onKeyDown={searchDataOnEnter}
              />
            </Grid>
            <Grid item>
              <CustomDatePicker
                selectedDate={selectedFromDate}
                handleDateChange={handleFromDateChange}
                label="Select Start Date"
              />
            </Grid>
            <Grid item>
              <CustomDatePicker
                selectedDate={selectedToDate}
                handleDateChange={handleToDateChange}
                label="Select End Date"
              />
            </Grid>
            <Grid item>
              <Button
                variant="contained"
                color="primary"
                style={{ top: '1rem', width: 100 }}
                size="medium"
                onClick={() => setRefresh(!refresh)}
              >
                Refresh
              </Button>
            </Grid>
            <Grid item>
              <Button
                variant="contained"
                color="primary"
                style={{ top: '1rem', width: 100 }}
                size="medium"
                // onClick={filterData}
              >
                Filter
              </Button>
            </Grid>
          </Grid>
          {/* <CustomTable rows={rows} columns={columns} /> */}
        </>
      )}
    </ViewContainer>
  );
}

export default Tickets;
