import { Card, CardContent, CardHeader } from '@material-ui/core';
import { SupervisedUserCircleOutlined } from '@material-ui/icons';
import React from 'react';

function ViewContainer({ icon, children, title }) {
  return (
    <Card variant="elevation">
      <CardHeader
        avatar={icon ? icon : <SupervisedUserCircleOutlined />}
        title={title ? title : 'Dashboard'}
        style={{ height: '10px', backgroundColor: '#D4D4D4', fontSize: 20 }}
      />
      {/* <hr /> */}
      <CardContent>{children}</CardContent>
    </Card>
  );
}

export default ViewContainer;
