import React from 'react';
import { DropzoneAreaBase } from 'material-ui-dropzone';
import { ConfirmationNumberRounded } from '@material-ui/icons';
import ViewContainer from './ViewContainer';
import { makeStyles } from '@material-ui/core/styles';
import { Button } from '@material-ui/core';
import CloudUploadIcon from '@material-ui/icons/CloudUpload';
import logo from '../assets/logo.png';
import * as XLSX from 'xlsx';
import { API } from '../config';

const useStyles = makeStyles((theme) => ({
  item: {
    display: 'flex',
    alignItems: 'center',
  },
  image: {
    height: '100%',
  },
  removeButton: {
    marginLeft: theme.spacing(1),
  },
  previewChip: {
    backgroundColor: theme.palette.grey[300],
    color: theme.palette.grey[800],
    marginRight: theme.spacing(1),
  },
}));

const acceptedFileTypes = [
  'application/vnd.ms-excel',
  'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
  'text/csv',
];

const handlePreviewIcon = (fileObject, classes) => {
  return logo;
};

function DatabaseUpload(props) {
  let contacts = [];
  async function handleFileUpload(files) {
    const file = files[0].file;
    const fileSize = file.size;
    const maxRowsPerIteration = 10;
    console.log(file, fileSize);

    if (!(file instanceof Blob)) {
      console.error('Invalid file object');
      return;
    }

    if (
      file.type === 'application/vnd.ms-excel' ||
      file.type ===
        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
    ) {
      const workbook = XLSX.read(await file.arrayBuffer(), { type: 'array' });
      const sheetName = workbook.SheetNames[0];
      const sheet = workbook.Sheets[sheetName];
      const rows = XLSX.utils.sheet_to_json(sheet);
      console.log(rows);

      for (let i = 0; i < rows.length; i += maxRowsPerIteration) {
        const chunk = rows.slice(i, i + maxRowsPerIteration);

        chunk.map((item) => {
          console.log(item);

          let phoneNumber = item['254710754471 -\r\nEUTICUS MUNENE\r\nMWANGI']
            .split('-')[0]
            .trim();

          console.log(phoneNumber);
          if (!Number(phoneNumber)) {
            console.log('Invalid Number');
          } else {
            contacts.push(phoneNumber);
          }

          return phoneNumber;
          // console.log(chunk);
          // for
          // Process the rows in this chunk as needed
        });
      }
    } else if (file.type === 'text/csv') {
      for (let offset = 0; offset < fileSize; offset += maxRowsPerIteration) {
        console.log(offset);
        const fileReader = new FileReader();
        const blob = file.slice(offset, offset + maxRowsPerIteration);
        const arrayBuffer = await new Promise((resolve) => {
          fileReader.onload = () => resolve(fileReader.result);
          fileReader.readAsArrayBuffer(blob);
        });

        const workbook = XLSX.read(arrayBuffer, { type: 'array' });
        const sheetName = workbook.SheetNames[0];
        const sheet = workbook.Sheets[sheetName];
        const csvString = XLSX.utils.sheet_to_csv(sheet);
        const rows = csvString.split('\n');
        const rowsFromChunk = rows.map((row) => row.split(','));

        console.log(rowsFromChunk);
        // Process the rows from this chunk as needed
      }
    } else {
      console.log('Invalid file');
    }
    console.log(contacts);
    fetch(`${API}/api/upload-database-number`, {
      method: 'POST', // or 'PUT'
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({
        mobile: contacts,
      }),
    });
  }

  // async function handleFileUpload(files) {
  //   const file = files[0].file;
  //   const fileSize = file.size;
  //   const maxRowsPerIteration = 10000;
  //   console.log(file, fileSize);

  //   if (!(file instanceof Blob)) {
  //     console.error('Invalid file object');
  //     return;
  //   }

  //   for (let offset = 0; offset < fileSize; offset += maxRowsPerIteration) {
  //     console.log(offset);
  //     const fileReader = new FileReader();
  //     const blob = file.slice(offset, offset + maxRowsPerIteration);
  //     const arrayBuffer = await new Promise((resolve) => {
  //       fileReader.onload = () => resolve(fileReader.result);
  //       fileReader.readAsArrayBuffer(blob);
  //     });

  //     const workbook = XLSX.read(arrayBuffer, { type: 'array' });
  //     const sheetName = workbook.SheetNames[0];
  //     const sheet = workbook.Sheets[sheetName];
  //     const csvString = XLSX.utils.sheet_to_csv(sheet);
  //     const rows = csvString.split('\n');
  //     const rowsFromChunk = rows.map((row) => row.split(','));

  //     console.log(rowsFromChunk);
  //     // Process the rows from this chunk as needed
  //   }
  // }

  return (
    <ViewContainer icon={<ConfirmationNumberRounded />} title="Database Center">
      <div>
        <DropzoneAreaBase
          onAdd={handleFileUpload}
          acceptedFiles={acceptedFileTypes}
          filesLimit={1}
          maxFileSize={1000000000}
          dropzoneText={'Drag and drop Excel or CSV files here or click'}
          showFileNames={true}
          showPreviews={true}
          showFileNamesInPreview={true}
          fileObjects={[]}
          onDelete={(deleteFileObj) => console.log('onDelete', deleteFileObj)}
          getPreviewIcon={handlePreviewIcon}
        />
      </div>
    </ViewContainer>
  );
}

export default DatabaseUpload;
